let mix = require('laravel-mix');
var readDir = require('readdir');

/**
 * We'll load jQuery and the Bootstrap jQuery plugin which provides support
 * for JavaScript based Bootstrap features such as modals and tabs. This
 * code may be modified to fit the specific needs of your application.
 */

try {
    window.$ = window.jQuery = require('jquery');
    window.Popper = Popper;
    require('bootstrap');
} catch (e) {}


var folderSource = "resources/dist";
var folderDestination = "public/dist";
var pathWeb = "jrfood.local";

/*
 |--------------------------------------------------------------------------
 | Mix Asset Management
 |--------------------------------------------------------------------------
 |
 | Mix provides a clean, fluent API for defining some Webpack build steps
 | for your Laravel application. By default, we are compiling the Sass
 | file for the application as well as bundling up all the JS files.
 |
 */


	// mix.js(folderSource+'/js/main.js', folderDestination+'/js')
	// 	.combine([folderSource+'/js/main/*'], folderDestination+'/js/main.js')
	// 	.minify(folderDestination+'/js/main.js')
 //        .copyDirectory(folderSource+'/img', folderDestination+'/img');

    // mix.copyDirectory(folderSource+'/css', folderDestination+'/css');
    // mix.copyDirectory(folderSource+'/fonts', folderDestination+'/fonts');
    // mix.copyDirectory(folderSource+'/images', folderDestination+'/images');

    mix.autoload({
        jquery: ['$', 'window.jQuery', 'jQuery'],
        'popper.js/dist/umd/popper.js': ['Popper']
    })

const pathFolders = folderSource+"/sass";
var filename = "";
var split_filetype = "";
var fileArray = readDir.readSync(pathFolders,['**.sass']);
var pathFolderOther = "";
    for (var i in fileArray){
        var split_file = fileArray[i].split("/");
        pathFolderOther = "";
        filename = "";
		split_filetype = "";

        if (split_file.length>1)
        {
            for (var j=0;j<split_file.length-1;j++)
            {
                pathFolderOther += "/"+split_file[j];
            }
        }

        split_filetype = split_file[split_file.length-1].split(".");
        filename = split_filetype[0];

        var name = pathFolders+'/'+fileArray[i];
        //console.log(name+"=="+filename+"=="+"public/dist/css"+pathFolderOther+"/"+filename+".css");
        mix.sass(name, folderDestination+'/css'+pathFolderOther)
            .options({
                processCssUrls: false
            })
            .minify(folderDestination+"/css"+pathFolderOther+"/"+filename+".css");
    }


pathFolder = folderSource+"/js";
filename = "";
split_filetype = "";
fileArray = readDir.readSync(pathFolder,['**.js']);
pathFolderOther = "";
    for (var i in fileArray){
        split_file = fileArray[i].split("/");
        pathFolderOther = "";
        filename = "";
		split_filetype = "";

        if (split_file.length>1)
        {
            for (var j=0;j<split_file.length-1;j++)
            {
                pathFolderOther += "/"+split_file[j];
            }
        }

        split_filetype = split_file[split_file.length-1].split(".");
        filename = split_filetype[0];

        name = pathFolder+'/'+fileArray[i];
        //console.log(name+"=="+filename+"=="+"public/dist/css"+pathFolderOther+"/"+filename+".css");
        mix.js(name, folderDestination+'/js'+pathFolderOther)
            .minify(folderDestination+"/js"+pathFolderOther+"/"+filename+".js");
    }

    const PATHS = {
        src: 'src',
        dist: '.',
        proxy: 'http://jrfood.local'
    };


//mix.browserSync(pathWeb);
mix.disableSuccessNotifications()
.setPublicPath(PATHS.dist)
.options({ processCssUrls: false })

mix.browserSync({
    port: 3001,
    ui: false,
    injectChanges: true,
    notify: false,
    host: 'localhost',
    proxy: `${PATHS.proxy}`
});
