<?php $__env->startSection('page_title', 'Banners'); ?>
<?php $__env->startSection('page_action', 'List Data'); ?>
<?php $__env->startSection('menu_active_banners',' active '); ?>

<?php $__env->startSection('page_nav'); ?>
<li><a href="<?php echo e(Route('cms.banners.index')); ?>">Banners</a></li>
<li class="active">List Data</li>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('page_style'); ?>
<?php $__env->stopSection(); ?>


<?php $__env->startSection('content'); ?>
<!-- Content Header (Page header) -->

<section class="section-container section-with-top-border p-b-5">

  <?php echo $__env->make('layouts.web-admin.massage_block', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

  <div class="row">
    <div class="col-md-12">


      <div class="panel">
        <div class="panel-heading">

          <div class="panel-heading-btn">
            <div class="pull-right">
              <button class="btn btn-default-sm" type="button" onclick="js_searchData('banners')">
                <i class="fa fa-search"></i>
              </button>
            </div>
            <div class="pull-right">
              <?php if(isset($arr_data["search"])): ?>
              <input type="text" class="form-control" name="search" id="search" value="<?php echo e($arr_data['search']); ?>"
                placeholder="Search...">
              <?php else: ?>
              <input type="text" class="form-control" name="search" id="search" placeholder="Search...">
              <?php endif; ?>
            </div>
          </div>

          <h4 class="panel-title">
            Total number of Banners : <?php echo e($banners->total()); ?>

            <?php if($hasPermission["create-banners"]): ?>
            &nbsp;&nbsp;
            <a href="javascript:void(0)" onclick="location='<?php echo e(Route('cms.banners.create')); ?>'"
              class="btn btn-xs btn-icon btn-circle btn-grey" data-click="panel-collapse" title="Add Data"><i
                class="fa fa-plus"></i></a>
            <?php endif; ?>
            <?php if($hasPermission["edit-banners"]): ?>
            &nbsp;&nbsp;
            <a href="javascript:void(0)" onclick="js_deleteAllSubContent('banners')"
              class="btn btn-xs btn-icon btn-circle btn-danger" data-click="panel-collapse" title="Delete Data"><i
                class="fas fa-minus"></i></a>

            <?php endif; ?>
          </h4>
        </div>

        <!-- /.box-header -->
        <div id="data-table_wrapper" class="dataTables_wrapper form-inline dt-bootstrap no-footer">

          <table id="tbl_dataList" rel="banners"
            class="table table-bordered table-hover dataTable no-footer dtr-inline table-responsive">
            <thead>
              <tr>
                <th style="width: 4%">
                  <?php if($arr_data["orderByUrl"] == "order_by"): ?>
                  
                  <?php if($arr_data["ascdesc"] == "ASC"): ?>
                  <a href="javascript:void(0)"><i class="fas fa-sort-alpha-down pull-right"></i></a>
                  <?php endif; ?>
                  <?php else: ?>
                  <a
                    href="<?php echo e(url(config('config.config_pathCms').'/banners')); ?>/order_by/ASC<?php echo e($arr_data['urlSearch']); ?>?page=<?php echo e($banners->currentPage()); ?>"><i
                      class="fas fa-sort-alpha-up pull-right text-muted"></i></a>
                  <?php endif; ?>
                </th>
                <th class="text-center" style="width: 4%">
                  <p class=""><input type="checkbox" id="chk_all" onclick="js_chkAll()" class="chk_all" value="Y"></p>
                </th>
                <th style="width: 5%">
                  <p class="pull-left">รูป</p>
                </th>
                <th style="width:46%">
                  <p class="pull-left">ชื่อ</p>
                  <p class="pull-right">
                    <?php if($arr_data["orderByUrl"] == "title"): ?>
                    <?php if($arr_data["ascdesc"] == "asc"): ?>
                    <a href="<?php echo e(url(config('config.config_pathCms').'/banners')); ?>/title/DESC<?php echo e($arr_data['urlSearch']); ?>?page=<?php echo e($banners->currentPage()); ?>"
                      class="pull-right"><i class="fas fa-sort-alpha-down"></i></a>
                    <?php else: ?>
                    <a href="<?php echo e(url(config('config.config_pathCms').'/banners')); ?>/title/ASC<?php echo e($arr_data['urlSearch']); ?>?page=<?php echo e($banners->currentPage()); ?>"
                      class="pull-right"><i class="fas fa-sort-alpha-up"></i></a>
                    <?php endif; ?>
                    <?php else: ?>
                    <a href="<?php echo e(url(config('config.config_pathCms').'/banners')); ?>/title/DESC<?php echo e($arr_data['urlSearch']); ?>?page=<?php echo e($banners->currentPage()); ?>"
                      class="pull-right"><i class="fas fa-sort-alpha-down text-muted"></i></a>
                    <?php endif; ?>
                  </p>
                </th>
                <th style="width: 6%">
                  <p class="pull-left">Status</p>
                </th>
                <th style="width: 20%">
                  <p class="pull-left">Modified date</p>
                  <p class="pull-right">
                    <?php if($arr_data["orderByUrl"] == "modify"): ?>
                    <?php if($arr_data["ascdesc"] == "asc"): ?>
                    <a href="<?php echo e(url(config('config.config_pathCms').'/banners')); ?>/modify/DESC<?php echo e($arr_data['urlSearch']); ?>?page=<?php echo e($banners->currentPage()); ?>"
                      class="pull-right"><i class="fas fa-sort-alpha-down"></i></a>
                    <?php else: ?>
                    <a href="<?php echo e(url(config('config.config_pathCms').'/banners')); ?>/modify/ASC<?php echo e($arr_data['urlSearch']); ?>?page=<?php echo e($banners->currentPage()); ?>"
                      class="pull-right"><i class="fas fa-sort-alpha-up"></i></a>
                    <?php endif; ?>
                    <?php else: ?>
                    <a href="<?php echo e(url(config('config.config_pathCms').'/banners')); ?>/modify/DESC<?php echo e($arr_data['urlSearch']); ?>?page=<?php echo e($banners->currentPage()); ?>"
                      class="pull-right"><i class="fas fa-sort-alpha-down text-muted"></i></a>
                    <?php endif; ?>
                  </p>
                </th>
                <th class="text-center" style="width: 15%">
                  <p class="">Process</p>
                </th>
              </tr>
            </thead>
            <tbody>
              <?php if(isset($banners) && $banners->count()>0): ?>
              <?php $__currentLoopData = $banners; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $banner): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
              <tr class="tr_sorted" rel="tr_<?php echo e($banner->id); ?>">
                <td class="text-center"><i class="fa fa-bars <?php echo e($arr_data['status_icon_sort']); ?> class_icon_sort"
                    aria-hidden="true"></i></td>
                <td class="text-center">
                  <input type="checkbox" id="chk_<?php echo e($banner->id); ?>" name="chk_<?php echo e($banner->id); ?>" class="class_chk"
                    value="<?php echo e($banner->id); ?>"></input>
                </td>
                <td>
                  <img
                    src="<?php echo e(!empty($banner) && Helper::storageProcess("get",$banner->pathFile,$banner->thumb)!=""?Helper::storageProcess("get",$banner->pathFile,$banner->thumb): asset('assets/noimage.jpg')); ?>"
                    id="img_responsive" style="width: 100px;">
                </td>
                <td>
                  <?php echo e($banner->title); ?><br /><br />
                  <small>Start Date :
                    <?php echo e(!empty($banner->startDate)?\Carbon\Carbon::parse($banner->startDate)->format('d/m/Y'):''); ?></small><br />
                  <small>Endn Date :
                    <?php echo e(!empty($banner->endDate)?\Carbon\Carbon::parse($banner->endDate)->format('d/m/Y'):''); ?></small><br />
                </td>
                <td>
                  <?php if(!$hasPermission["edit-banners"]): ?>
                  <a id="btn_statusDataActive-<?php echo e($banner->id); ?>" href="javascript:void(0)"
                    class="btn btn-success btn-xs btn-rounded p-l-10 p-r-10">
                    <?php echo e(config('config.config_arr_status')["Y"]); ?></a>
                  <?php else: ?>
                  <?php if($banner->status==="Active"): ?>
                  <a id="btn_statusDataActive-<?php echo e($banner->id); ?>" href="javascript:void(0)"
                    onclick="js_changeStatus('banners',<?php echo e($banner->id); ?>,'Active')"
                    class="btn btn-success btn-xs btn-rounded p-l-10 p-r-10">
                    <?php echo e(config('config.config_arr_status')["Y"]); ?></a>

                  <a id="btn_statusDataInactive-<?php echo e($banner->id); ?>" href="javascript:void(0)"
                    onclick="js_changeStatus('banners',<?php echo e($banner->id); ?>,'Inactive')"
                    class="btn btn-danger btn-xs btn-rounded p-l-10 p-r-10 hide">
                    <?php echo e(config('config.config_arr_status')["N"]); ?></a>

                  <?php else: ?>
                  <a id="btn_statusDataActive-<?php echo e($banner->id); ?>" href="javascript:void(0)"
                    onclick="js_changeStatus('banners',<?php echo e($banner->id); ?>,'Active')"
                    class="btn btn-success btn-xs btn-rounded p-l-10 p-r-10 hide">
                    <?php echo e(config('config.config_arr_status')["Y"]); ?></a>

                  <a id="btn_statusDataInactive-<?php echo e($banner->id); ?>" href="javascript:void(0)"
                    onclick="js_changeStatus('banners',<?php echo e($banner->id); ?>,'Inactive')"
                    class="btn btn-danger btn-xs btn-rounded p-l-10 p-r-10 ">
                    <?php echo e(config('config.config_arr_status')["N"]); ?></a>
                  <?php endif; ?>
                  <?php endif; ?>
                </td>
                <td>
                  
                  <?php echo e(\Carbon\Carbon::parse($banner->created_at)->format("d/m/Y H:i:s")); ?><br>
                  <?php if(!empty($banner->updated_by)): ?>
                  Edit By : <?php echo e(\User::find($banner->updated_by)->first()->name); ?>

                  <?php endif; ?>
                </td>
                <td>
                  <a href="<?php echo e(Route('cms.banners.show',['id'=>$banner->id])); ?>"
                    class="btn btn-default btn-xs btn-block btn-rounded p-l-10 p-r-10"><i
                      class="fa fa-fw fa-play"></i>View</a>
                  <?php if($hasPermission["edit-banners"]): ?>
                  <a href="<?php echo e(Route('cms.banners.edit',['id'=>$banner->id])); ?>"
                    class="btn btn-default btn-xs btn-block btn-rounded p-l-10 p-r-10"><i
                      class="fa fa-fw fa-edit"></i>Edit</a>

                  <a href="javascript:void(0)" onclick="js_deleteContent('banners','<?php echo e($banner->id); ?>')"
                    class="btn btn-danger btn-xs btn-block btn-rounded p-l-10 p-r-10"><i
                      class="fa fa-fw fa-trash"></i>Delete</a>
                  <?php endif; ?>
                </td>
              </tr>
              <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
              <?php else: ?>
              <tr>
                <td colspan="7" class="text-danger text-center">--No Data--</td>
              </tr>
              <?php endif; ?>
            </tbody>
          </table>

          <div class="row" style="margin-bottom: 10px;">
            <div class="col-md-5 col-sm-7">
              <div class="row">
                <div class="col-lg-2 col-md-4 col-sm-4 text-right">
                  <?php echo Form::select('option_limit_page', config('config.config_arr_limit_page'),
                  Session::get('limit_page.banners'),
                  ["class"=>"form-control","id"=>"option_limit_page","onchange"=>"js_changeLimitPage('banners',this.value)"]);; ?>

                </div>
                <div class="col-lg-10 col-md-8 col-sm-8">
                  Showing <?php echo e($banners->firstItem()); ?> to <?php echo e($banners->lastItem()); ?> of <?php echo e($banners->total()); ?> entries
                </div>
              </div>
            </div>
            <!-- /.col-sm-5 -->
            <div class="col-sm-7 text-right">
              <?php echo e($banners->render()); ?>

            </div>
            <!-- /.col-sm-7 -->

          </div>
          <!-- /.row -->

        </div>
        <!-- /.box-header -->

      </div>
      <!-- /.box -->


    </div>
    <!-- /.col -->
  </div>
  <!-- /.row -->
</section>
<!-- /.content -->

<?php $__env->stopSection(); ?>


<?php $__env->startSection('page_script'); ?>
<?php echo Html::script('js/functionjs.js'); ?>

<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.web-admin.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/cp885822/public_html/jrfnb.co.th/resources/views/web-admin/banners/index.blade.php ENDPATH**/ ?>