<?php

use Illuminate\Http\Request;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| is assigned the "api" middleware group. Enjoy building your API!
|
*/

Route::middleware('auth:api')->get('/user', function (Request $request) {
    return $request->user();
});

Route::group(['prefix'=>'/system', 'as' => 'api.system.', 'namespace' => 'Api', 'middleware' => ['cors']],function(){
    Route::post('/sendContact', 'SystemsApiController@sendContact')->name('sendContact');
});


Route::group(['prefix'=>'/banners','as'=>"api.banners.",'namespace' => 'Api', 'middleware' => ['cors']],function(){
    Route::get('/', 'BannersApiController@index')->name("index");
    Route::get('/{id}', 'BannersApiController@show')->name("show");
    Route::post('/', 'BannersApiController@store')->name("store");
    Route::patch('/{id}', 'BannersApiController@update')->name("update");
    Route::delete('/{id}', 'BannersApiController@delete')->name("delete");
});