@extends('layouts.web-admin.main')

@section('page_title', 'Products')
@section('page_action', 'Edit Data')
@section('menu_active_products',' active ')
@section('submenu_active_products',' active ')

@section('page_style')
@stop

@section('page_nav')
  <li><a href="{{Route('cms.products.product.index')}}">Products</a></li>
  <li class="active">View Data</li>
@stop

@section('content')
<!-- Main content -->
<section class="section-container section-with-top-border p-b-5">

  <div class="row">
    <div class="col-md-12">

        @if($errors->any())
          <ul class="alert alert-danger">
            @foreach($errors->all() as $error)
              <li>{{ $error }}</li>
            @endforeach
          </ul>
        @endif

        <div class="panel p-20">
            <!-- /.box-header -->
            <!-- form start -->

              {!! Form::model($product, ['method' => 'put','class'=>"form-horizontal",'files' => true,'action'=>['Webadmin\ProductsController@update', $product->id]]) !!}
                  @include('web-admin.products._form',['action_page' => 'view'])
              {!! Form::close() !!}


          </div>


    </div>
    <!-- /.col -->
  </div>
  <!-- /.row -->
</section>
<!-- /.content -->
@stop


@section('page_script')
@stop
