@extends('layouts.web-admin.main')

@section('page_title', 'Contents')
@section('page_action', 'List Data')
{{-- @section('menu_active_contents',' active ') --}}
@section('menu_active_contents',' active ')

@section('page_nav')
<li><a href="{{Route('cms.contents.index')}}">Contents</a></li>
<li class="active">List Data</li>
@stop

@section('page_style')
@stop


@section('content')
<!-- Content Header (Page header) -->

<section class="section-container section-with-top-border p-b-5">

  @include('layouts.web-admin.massage_block')

  <div class="row">
    <div class="col-md-12">


      <div class="panel">
        <div class="panel-heading">

          <div class="panel-heading-btn">
            <div class="pull-right">
              <button class="btn btn-default-sm" type="button" onclick="js_searchData('contents')">
                <i class="fa fa-search"></i>
              </button>
            </div>
            <div class="pull-right">
              @if (isset($arr_data["search"]))
              <input type="text" class="form-control" name="search" id="search" value="{{ $arr_data['search'] }}"
                placeholder="Search...">
              @else
              <input type="text" class="form-control" name="search" id="search" placeholder="Search...">
              @endif
            </div>
          </div>

          <h4 class="panel-title">
            Total number of Contents : {{ $contents->total() }}
            @if ($hasPermission["create-contents"])
            &nbsp;&nbsp;
            <a href="javascript:void(0)" onclick="location='{{Route('cms.contents.create')}}'"
              class="btn btn-xs btn-icon btn-circle btn-grey" data-click="panel-collapse" title="Add Data"><i
                class="fa fa-plus"></i></a>
            @endif
            @if ($hasPermission["edit-contents"])
            &nbsp;&nbsp;
            <a href="javascript:void(0)" onclick="js_deleteAllSubContent('contents')"
              class="btn btn-xs btn-icon btn-circle btn-danger" data-click="panel-collapse" title="Delete Data"><i
                class="fas fa-minus"></i></a>

            @endif
          </h4>
        </div>

        <!-- /.box-header -->
        <div id="data-table_wrapper" class="dataTables_wrapper form-inline dt-bootstrap no-footer">

          <table id="tbl_dataList" rel="contents"
            class="table table-bordered table-hover dataTable no-footer dtr-inline table-responsive">
            <thead>
              <tr>
                <th style="width: 4%">
                  @if ($arr_data["orderByUrl"] == "order_by")
                  {{-- {{$arr_data["orderByUrl"]."==".$arr_data["ascdesc"]}} --}}
                  @if ($arr_data["ascdesc"] == "ASC")
                  <a href="javascript:void(0)"><i class="fas fa-sort-alpha-down pull-right"></i></a>
                  @endif
                  @else
                  <a
                    href="{{ url(config('config.config_pathCms').'/contents') }}/order_by/ASC{{ $arr_data['urlSearch'] }}?page={{ $contents->currentPage() }}"><i
                      class="fas fa-sort-alpha-up pull-right text-muted"></i></a>
                  @endif
                </th>
                <th class="text-center" style="width: 4%">
                  <p class=""><input type="checkbox" id="chk_all" onclick="js_chkAll()" class="chk_all" value="Y"></p>
                </th>
                <th style="width: 5%">
                  <p class="pull-left">รูป</p>
                </th>
                <th style="width:46%">
                  <p class="pull-left">ชื่อ</p>
                  <p class="pull-right">
                    @if ($arr_data["orderByUrl"] == "title")
                    @if ($arr_data["ascdesc"] == "asc")
                    <a href="{{ url(config('config.config_pathCms').'/contents') }}/title/DESC{{ $arr_data['urlSearch'] }}?page={{ $contents->currentPage() }}"
                      class="pull-right"><i class="fas fa-sort-alpha-down"></i></a>
                    @else
                    <a href="{{ url(config('config.config_pathCms').'/contents') }}/title/ASC{{ $arr_data['urlSearch'] }}?page={{ $contents->currentPage() }}"
                      class="pull-right"><i class="fas fa-sort-alpha-up"></i></a>
                    @endif
                    @else
                    <a href="{{ url(config('config.config_pathCms').'/contents') }}/title/DESC{{ $arr_data['urlSearch'] }}?page={{ $contents->currentPage() }}"
                      class="pull-right"><i class="fas fa-sort-alpha-down text-muted"></i></a>
                    @endif
                  </p>
                </th>
                <th style="width: 6%">
                  <p class="pull-left">Status</p>
                </th>
                <th style="width: 20%">
                  <p class="pull-left">Modified date</p>
                  <p class="pull-right">
                    @if ($arr_data["orderByUrl"] == "modify")
                    @if ($arr_data["ascdesc"] == "asc")
                    <a href="{{ url(config('config.config_pathCms').'/contents') }}/modify/DESC{{ $arr_data['urlSearch'] }}?page={{ $contents->currentPage() }}"
                      class="pull-right"><i class="fas fa-sort-alpha-down"></i></a>
                    @else
                    <a href="{{ url(config('config.config_pathCms').'/contents') }}/modify/ASC{{ $arr_data['urlSearch'] }}?page={{ $contents->currentPage() }}"
                      class="pull-right"><i class="fas fa-sort-alpha-up"></i></a>
                    @endif
                    @else
                    <a href="{{ url(config('config.config_pathCms').'/contents') }}/modify/DESC{{ $arr_data['urlSearch'] }}?page={{ $contents->currentPage() }}"
                      class="pull-right"><i class="fas fa-sort-alpha-down text-muted"></i></a>
                    @endif
                  </p>
                </th>
                <th class="text-center" style="width: 15%">
                  <p class="">Process</p>
                </th>
              </tr>
            </thead>
            <tbody>
              @if (isset($contents) && $contents->count()>0)
              @foreach($contents as $content)
              <tr class="tr_sorted" rel="tr_{{ $content->id }}">
                <td class="text-center"><i class="fa fa-bars {{ $arr_data['status_icon_sort'] }} class_icon_sort"
                    aria-hidden="true"></i></td>
                <td class="text-center">
                  <input type="checkbox" id="chk_{{ $content->id }}" name="chk_{{ $content->id }}" class="class_chk"
                    value="{{ $content->id }}" />
                </td>
                <td>
                  <img
                    src="{{ !empty($content) && Helper::storageProcess("get",$content->pathFile,$content->thumb)!=""?Helper::storageProcess("get",$content->pathFile,$content->thumb): asset('assets/noimage.jpg') }}"
                    id="img_responsive" style="width: 100px;">
                </td>
                <td>
                  {{ $content->title_th." / ".$content->title_en }}<br /><br />
                  <small>Start Date :
                    {{ !empty($content->startDate)?\Carbon\Carbon::parse($content->startDate)->format('d/m/Y'):''}}</small><br />
                  <small>Endn Date :
                    {{ !empty($content->endDate)?\Carbon\Carbon::parse($content->endDate)->format('d/m/Y'):''}}</small><br />
                </td>
                <td>
                  @if (!$hasPermission["edit-contents"])
                  <a id="btn_statusDataActive-{{$content->id}}" href="javascript:void(0)"
                    class="btn btn-success btn-xs btn-rounded p-l-10 p-r-10">
                    {{ config('config.config_arr_status')["Y"] }}</a>
                  @else
                  @if ($content->status==="Active")
                  <a id="btn_statusDataActive-{{$content->id}}" href="javascript:void(0)"
                    onclick="js_changeStatus('contents',{{ $content->id }},'Active')"
                    class="btn btn-success btn-xs btn-rounded p-l-10 p-r-10">
                    {{ config('config.config_arr_status')["Y"] }}</a>

                  <a id="btn_statusDataInactive-{{$content->id}}" href="javascript:void(0)"
                    onclick="js_changeStatus('contents',{{ $content->id }},'Inactive')"
                    class="btn btn-danger btn-xs btn-rounded p-l-10 p-r-10 hide">
                    {{ config('config.config_arr_status')["N"] }}</a>

                  @else
                  <a id="btn_statusDataActive-{{$content->id}}" href="javascript:void(0)"
                    onclick="js_changeStatus('contents',{{ $content->id }},'Active')"
                    class="btn btn-success btn-xs btn-rounded p-l-10 p-r-10 hide">
                    {{ config('config.config_arr_status')["Y"] }}</a>

                  <a id="btn_statusDataInactive-{{$content->id}}" href="javascript:void(0)"
                    onclick="js_changeStatus('contents',{{ $content->id }},'Inactive')"
                    class="btn btn-danger btn-xs btn-rounded p-l-10 p-r-10 ">
                    {{ config('config.config_arr_status')["N"] }}</a>
                  @endif
                  @endif
                </td>
                <td>
                  {{-- {{ \Carbon\Carbon::parse($content->created_at)->diffForHumans() }}<br> --}}
                  {{ \Carbon\Carbon::parse($content->created_at)->format("d/m/Y H:i:s") }}<br>
                  @if (!empty($content->updated_by))
                  Edit By : {{\User::find($content->updated_by)->first()->name}}
                  @endif
                </td>
                <td>
                  <a href="{{ Route('cms.contents.show',['id'=>$content->id]) }}"
                    class="btn btn-default btn-xs btn-block btn-rounded p-l-10 p-r-10"><i
                      class="fa fa-fw fa-play"></i>View</a>
                  @if ($hasPermission["edit-contents"])
                  <a href="{{ Route('cms.contents.edit',['id'=>$content->id]) }}"
                    class="btn btn-default btn-xs btn-block btn-rounded p-l-10 p-r-10"><i
                      class="fa fa-fw fa-edit"></i>Edit</a>

                  <a href="javascript:void(0)" onclick="js_deleteContent('contents','{{ $content->id }}')"
                    class="btn btn-danger btn-xs btn-block btn-rounded p-l-10 p-r-10"><i
                      class="fa fa-fw fa-trash"></i>Delete</a>
                  @endif
                </td>
              </tr>
              @endforeach
              @else
              <tr>
                <td colspan="7" class="text-danger text-center">--No Data--</td>
              </tr>
              @endif
            </tbody>
          </table>

          <div class="row" style="margin-bottom: 10px;">
            <div class="col-md-5 col-sm-7">
              <div class="row">
                <div class="col-lg-2 col-md-4 col-sm-4 text-right">
                  {!! Form::select('option_limit_page', config('config.config_arr_limit_page'),
                  Session::get('limit_page.contents'),
                  ["class"=>"form-control","id"=>"option_limit_page","onchange"=>"js_changeLimitPage('contents',this.value)"]);
                  !!}
                </div>
                <div class="col-lg-10 col-md-8 col-sm-8">
                  Showing {{ $contents->firstItem() }} to {{ $contents->lastItem() }} of {{ $contents->total() }} entries
                </div>
              </div>
            </div>
            <!-- /.col-sm-5 -->
            <div class="col-sm-7 text-right">
              {{ $contents->render() }}
            </div>
            <!-- /.col-sm-7 -->

          </div>
          <!-- /.row -->

        </div>
        <!-- /.box-header -->

      </div>
      <!-- /.box -->


    </div>
    <!-- /.col -->
  </div>
  <!-- /.row -->
</section>
<!-- /.content -->

@stop


@section('page_script')
{!! Html::script('js/functionjs.js') !!}
@stop