<div class="form-group">
    {!! Form::label("startDate", "Start Date", ['class' => 'col-sm-2 control-label','for'=>'startDate']) !!}
    <div class="col-sm-5">
        <div class="input-group date">
            <input type="text" id="startDate"
                value="{{ old("startDate", !empty($startDate)?\Carbon\Carbon::parse($startDate)->format("d/m/Y"):'' ) }}"
                name="startDate" class="form-control" {{$action_page=="view"?"disabled":""}}>
        </div>
    </div>
</div>

<div class="form-group">
    {!! Form::label("endDate", "End Date", ['class' => 'col-sm-2 control-label','for'=>'endDate']) !!}
    <div class="col-sm-5">
        <div class="input-group date">
            <input type="text" id="endDate" name="endDate"
                value="{{ old("endDate", !empty($endDate)?\Carbon\Carbon::parse($endDate)->format("d/m/Y"):'' ) }}"
                class="form-control" {{$action_page=="view"?"disabled":""}}>
        </div>
    </div>
</div>

<script>
    $( function() {
      var config_dateFormat = "dd/mm/yy",
          from = $( "#startDate" )
            .datepicker({
              changeMonth: true,
              changeYear: true,
              yearRange: "1920:2028",
              dateFormat: config_dateFormat,
              numberOfMonths: 1,
              showOn: "both",//button
              buttonText: '<i class="fa fa-calendar"></i>'
            })
            .on( "change", function() {
              to.datepicker( "option", "minDate", getDate( this ) );
            }),
          to = $( "#endDate" ).datepicker({
            changeMonth: true,
            changeYear: true,
            yearRange: "1920:2028",
            dateFormat: config_dateFormat,
            numberOfMonths: 1,
            showOn: "both",//button
            buttonText: '<i class="fa fa-calendar"></i>'
          })
          .on( "change", function() {
            from.datepicker( "option", "maxDate", getDate( this ) );
          });
  
        function getDate( element ) {
          var date;
          try {
            date = $.datepicker.parseDate( config_dateFormat, element.value );
          } catch( error ) {
            date = null;
          }
          return date;
        }
      });
</script>