<!DOCTYPE html>
<html>

<head>
    <meta charset="utf-8" />
    <meta http-equiv="X-UA-Compatible" content="IE=edge" />
    <title>jrfnb company limited</title>
    <meta name="viewport" content="width=device-width, initial-scale=1" />
    <link href="https://fonts.googleapis.com/css?family=Roboto:300,400,500,700,900&display=swap" rel="stylesheet">
    <link
        href="https://fonts.googleapis.com/css2?family=Dosis:wght@600;700&family=Kosugi&family=Prompt:wght@300;400;500;700;900&display=swap"
        rel="stylesheet">
    <link rel="stylesheet" type="text/css" media="screen" href="{{url('dist/css/app.css')}}" />
    <link rel="stylesheet" type="text/css" media="screen" href="{{url('dist/css/microsite.css')}}" />
    <link rel="shortcut icon" href="{{url('dist/images/favicon.ico')}}" type="image/x-icon">
    <link rel="icon" href="{{url('dist/images/favicon.ico')}}" type="image/x-icon">
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    {{--
    <link href="https://fonts.googleapis.com/css2?family=Dosis:wght@600;700&family=Kosugi&display=swap"
        rel="stylesheet"> --}}
    <script src="https://kit.fontawesome.com/a1f31f4aab.js" crossorigin="anonymous"></script>
</head>

<body class="microsite {{ $category->color }}">
    <section class="container">
        <nav class="navbar navbar-expand-lg navbar bg-green">
            <a class="navbar-brand col-8 col-lg-3" href="#">
                <img src="{{url('dist/images/logo.png')}}" class="img-fluid" alt="">
            </a>
        </nav>
        <div class="banner">
            <img src="{{url('dist/images/microsite/banner-microsite.jpg')}}" class="img-fluid" alt="">
        </div>
        <div class="line"></div>
        <div class="row">
            <div class="col-6">
                <ul class="language">
                    <li> <a href="{{ url($category->slug . '/' . $brand->slug . '/' . $product->slug) }}?&lang=th"
                            class="{{ Session::get('locale')=='th' ? 'active' : '' }}"> <img
                                src="{{url('dist/images/microsite/icon-th.png')}}" width="40" class="img-fluid" alt="">
                            TH </a></li>
                    <li> <a href="{{ url($category->slug . '/' . $brand->slug . '/' . $product->slug) }}?&lang=en"
                            class="{{ Session::get('locale')=='en' ? 'active' : '' }}"> <img
                                src="{{url('dist/images/microsite/icon-en.png')}}" width="40" class="img-fluid" alt="">
                            EN </a></li>
                </ul>
            </div>
            <div class="col-6 text-right">
                <!-- <img src="{{url('dist/images/microsite/logo-microsite.jpg')}}" class="img-fluid" alt=""> -->
                <img src="{{ !empty($brand) && Helper::storageProcess('get',$brand->pathFile,$brand->thumb)!=''?Helper::storageProcess('get',$brand->pathFile,$brand->thumb): asset('assets/noimage.jpg') }}"
                    class="img-fluid" alt="" />
            </div>
        </div>
        <div class="row pt-5">
            <div class="col-12 col-lg-5 pb-5 text-center text-md-left">
                <!-- <img src="{{url('dist/images/microsite/product.png')}}" class="img-fluid" alt="">  -->
                <img src="{{ !empty($product) && Helper::storageProcess('get',$product->pathFile,$product->thumb)!=''?Helper::storageProcess('get',$product->pathFile,$product->thumb): asset('assets/noimage.jpg') }}"
                    class="img-fluid" alt="" />
            </div>
            <div class="col-12 col-lg-7">
                <div class="text-title"> <strong> {!! Session::get('locale')=="th" ? $product->title_th :
                        $product->title_en !!} </strong></div>
                <div class="product-name">{!! Session::get('locale')=="th" ? $product->product_name_th :
                    $product->product_name_en !!}</div>
                {!! Session::get('locale')=="th" ? $product->content_th : $product->content_en !!}
                <div class="recipe">
                    <img src="{{url('dist/images/microsite/icon-recipe.svg')}}" width="30" alt="">
                    <span>{{trans('menu.recipe')}}</span>
                </div>
                <div class="row">
                    @if (!empty($product) && Helper::storageProcess('get',$product->pathFile,$product->album_1)!='')
                    <div class="col-12 col-lg-4 pt-3"> <img
                            src="{{ Helper::storageProcess('get',$product->pathFile,$product->album_1) }}"
                            class="img-fluid" alt=""> </div>
                    @endif

                    @if (!empty($product) && Helper::storageProcess('get',$product->pathFile,$product->album_2)!='')
                    <div class="col-12 col-lg-4 pt-3"> <img
                            src="{{ Helper::storageProcess('get',$product->pathFile,$product->album_2) }}"
                            class="img-fluid" alt=""> </div>
                    @endif

                    @if (!empty($product) && Helper::storageProcess('get',$product->pathFile,$product->album_3)!='')
                    <div class="col-12 col-lg-4 pt-3"> <img
                            src="{{ Helper::storageProcess('get',$product->pathFile,$product->album_3) }}"
                            class="img-fluid" alt=""> </div>
                    @endif
                </div>
            </div>
        </div>
    </section>
    <!--page-->

    <!--=====================[Start] Menu slideout =========================-->
    <!--SCRIPT FOR ALL PAGES-->
    {!! Html::script('dist/js/app.min.js') !!}

    @include('layouts.front.functionjs')
    @yield('page_script')
    <!--END SCRIPT FOR ALL PAGES-->


</body>

</html>