var gulp = require('gulp');

var browserSync = require('browser-sync');

var sass = require('gulp-sass');





gulp.task('default', ['browser-sync'], function() {



    gulp.watch(['**/*.html'], browserSync.reload);

    gulp.watch(['css/**/*.css'], browserSync.reload);

    gulp.watch("scss/**/*.scss", ['sass']);

});



gulp.task('sass', function () {    

    return gulp.src(['scss/**/*.scss'])

        .pipe(sass({

         compass: true, 

         style: 'compressed', 

        }))

        .on('error', function (err) { 

         console.log(err.message); 

        })

        .pipe(gulp.dest('css')) 

});





gulp.task('browser-sync', function() {

    browserSync({

        server: {

            baseDir: "./"

        }

    });

});