/*   

Template Name: Source Admin - Responsive Admin Dashboard Template build with Twitter Bootstrap 3.3.7 & Bootstrap 4

Version: 1.4.0

Author: Sean Ngu

Website: http://www.seantheme.com/source-admin-v1.4/admin/

    ----------------------------

        APPS CONTENT TABLE

    ----------------------------

    

    <!-- ======== GLOBAL SCRIPT SETTING ======== -->

    01. Handle Sidebar   - Menu

    02. Handle Sidebar   - Mobile View Toggle

    03. Handle Sidebar   - Minify / Expand

    04. Handle Sidebar   - Mobile Scrolling Feature

    05. Handle Sidebar   - Clear Sidebar Selection

    06. Handle Top Menu  - Unlimited Top Menu Render

    07. Handle Top Menu  - Sub Menu Toggle

    08. Handle Top Menu  - Mobile Sub Menu Toggle

    09. Handle Top Menu  - Mobile Top Menu Toggle

    10. Handle Plugins   - Scrollbar

    11. Handle Plugins   - Bootstrap Tooltip & Popover

    12. Handle Page Load - Show Content

    13. Handle Scroll To Top

    14. Handle Panel     - Remove / Reload / Collapse / Expand

	

    <!-- ======== APPLICATION SETTING ======== -->

    Application Controller

*/



/* 01. Handle Sidebar - Menu

------------------------------------------------ */

var handleSidebarMenu = function() {

    "use strict";

    

    $('.sidebar .nav > .has-sub > a').click(function() {

        var target = $(this).next('.sub-menu');

        var otherMenu = '.sidebar .nav > li.has-sub > .sub-menu';



        if ($('.page-sidebar-minified').length === 0) {

            $(otherMenu).not(target).slideUp(250, function() {

                $(this).closest('li').removeClass('expand');

            });

            $(target).slideToggle(250, function() {

                var targetLi = $(this).closest('li');

                if ($(targetLi).hasClass('expand')) {

                    $(targetLi).removeClass('expand');

                } else {

                    $(targetLi).addClass('expand');

                }

            });

        }

    });

    $('.sidebar .nav > .has-sub .sub-menu li.has-sub > a').click(function() {

        if ($('.page-sidebar-minified').length === 0) {

            var target = $(this).next('.sub-menu');

            $(target).slideToggle(250);

        }

    });

};





/* 02. Handle Sidebar - Mobile View Toggle

------------------------------------------------ */

var handleMobileSidebarToggle = function() {

    "use strict";

    var sidebarProgress = false;

    $('.sidebar').bind('click touchstart', function(e) {

        if ($(e.target).closest('.sidebar').length !== 0) {

            sidebarProgress = true;

        } else {

            sidebarProgress = false;

            e.stopPropagation();

        }

    });



    $(document).bind('click touchstart', function(e) {

        if ($(e.target).closest('.sidebar').length === 0) {

            sidebarProgress = false;

        }

        if (!e.isPropagationStopped() && sidebarProgress !== true) {

            if ($('#page-container').hasClass('page-sidebar-toggled')) {

                sidebarProgress = true;

                $('#page-container').removeClass('page-sidebar-toggled');

            }

            if ($(window).width() <= 767) {

                if ($('#page-container').hasClass('page-right-sidebar-toggled')) {

                    sidebarProgress = true;

                    $('#page-container').removeClass('page-right-sidebar-toggled');

                }

            }

        }

    });



    $('[data-click=right-sidebar-toggled]').click(function(e) {

        e.stopPropagation();

        var targetContainer = '#page-container';

        var targetClass = 'page-right-sidebar-toggled';

        

        if ($(targetContainer).hasClass(targetClass)) {

            $(targetContainer).removeClass(targetClass);

        } else if (sidebarProgress !== true) {

            $(targetContainer).addClass(targetClass);

        } else {

            sidebarProgress = false;

        }

    });



    $('[data-click=sidebar-toggled]').click(function(e) {

        e.stopPropagation();

        var sidebarClass = 'page-sidebar-toggled';

        var targetContainer = '#page-container';



        if ($(targetContainer).hasClass(sidebarClass)) {

            $(targetContainer).removeClass(sidebarClass);

        } else if (sidebarProgress !== true) {

            $(targetContainer).addClass(sidebarClass);

        } else {

            sidebarProgress = false;

        }

        if ($(window).width() < 480) {

            $('#page-container').removeClass('page-right-sidebar-toggled');

        }

    });

};





/* 03. Handle Sidebar - Minify / Expand

------------------------------------------------ */

var handleSidebarMinify = function() {

    "use strict";

    $('[data-click=sidebar-minify]').click(function(e) {

        e.preventDefault();

        var sidebarClass = 'page-sidebar-minified';

        var targetContainer = '#page-container';

        $('#sidebar [data-scrollbar="true"]').css('margin-top','0');

        $('#sidebar [data-scrollbar="true"]').removeAttr('data-init');

        $('#sidebar [data-scrollbar=true]').stop();

        if ($(targetContainer).hasClass(sidebarClass)) {

            $(targetContainer).removeClass(sidebarClass);

            if ($(targetContainer).hasClass('page-sidebar-fixed')) {

                if ($('#sidebar .slimScrollDiv').length !== 0) {

                    $('#sidebar [data-scrollbar="true"]').slimScroll({destroy: true});

                    $('#sidebar [data-scrollbar="true"]').removeAttr('style');

                }

                generateSlimScroll($('#sidebar [data-scrollbar="true"]'));

                $('#sidebar [data-scrollbar=true]').trigger('mouseover');

            } else if(/Android|webOS|iPhone|iPad|iPod|BlackBerry|IEMobile|Opera Mini/i.test(navigator.userAgent)) {

                if ($('#sidebar .slimScrollDiv').length !== 0) {

                    $('#sidebar [data-scrollbar="true"]').slimScroll({destroy: true});

                    $('#sidebar [data-scrollbar="true"]').removeAttr('style');

                }

                generateSlimScroll($('#sidebar [data-scrollbar="true"]'));

            }

        } else {

            $(targetContainer).addClass(sidebarClass);

    

            if(!/Android|webOS|iPhone|iPad|iPod|BlackBerry|IEMobile|Opera Mini/i.test(navigator.userAgent)) {

                if ($(targetContainer).hasClass('page-sidebar-fixed')) {

                    $('#sidebar [data-scrollbar="true"]').slimScroll({destroy: true});

                    $('#sidebar [data-scrollbar="true"]').removeAttr('style');

                }

                $('#sidebar [data-scrollbar=true]').trigger('mouseover');

            } else {

                $('#sidebar [data-scrollbar="true"]').css('overflow', 'visible');

            }

        }

        $(window).trigger('resize');

    });

};





/* 04. Handle Sidebar - Mobile Scrolling Feature

------------------------------------------------ */

var handleMobileSidebar = function() {

    "use strict";

    if(/Android|webOS|iPhone|iPad|iPod|BlackBerry|IEMobile|Opera Mini/i.test(navigator.userAgent)) {

        if ($('#page-container').hasClass('page-sidebar-minified')) {

            $('#sidebar [data-scrollbar="true"]').css('overflow', 'visible');

            $('.page-sidebar-minified #sidebar [data-scrollbar="true"]').slimScroll({destroy: true});

            $('.page-sidebar-minified #sidebar [data-scrollbar="true"]').removeAttr('style');

            $('.page-sidebar-minified #sidebar [data-scrollbar=true]').trigger('mouseover');

        }

    }



    var oriTouch = 0;

    $('.page-sidebar-minified .sidebar [data-scrollbar=true] a').bind('touchstart', function(e) {

        var touch = e.originalEvent.touches[0] || e.originalEvent.changedTouches[0];

        var touchVertical = touch.pageY;

        oriTouch = touchVertical - parseInt($(this).closest('[data-scrollbar=true]').css('margin-top'));

    });



    $('.page-sidebar-minified .sidebar [data-scrollbar=true] a').bind('touchmove',function(e){

        e.preventDefault();

        if(/Android|webOS|iPhone|iPad|iPod|BlackBerry|IEMobile|Opera Mini/i.test(navigator.userAgent)) {

            var touch = e.originalEvent.touches[0] || e.originalEvent.changedTouches[0];

            var touchVertical = touch.pageY;

            var elementTop = touchVertical - oriTouch;

            

            $(this).closest('[data-scrollbar=true]').css('margin-top', elementTop + 'px');

        }

    });



    $('.page-sidebar-minified .sidebar [data-scrollbar=true] a').bind('touchend', function(e) {

        var targetScrollBar = $(this).closest('[data-scrollbar=true]');

        var windowHeight = $(window).height();

        var sidebarTopPosition = parseInt($('#sidebar').css('top'));

        var sidebarContainerHeight = $('#sidebar').height();

        oriTouch = $(targetScrollBar).css('margin-top');



        var sidebarHeight = sidebarTopPosition;

        $('.sidebar').not('.sidebar-right').find('.nav').each(function() {

            sidebarHeight += $(this).height();

        });

        var finalHeight = -parseInt(oriTouch) + $('.sidebar').height();

        if (finalHeight >= sidebarHeight && windowHeight <= sidebarHeight && sidebarContainerHeight <= sidebarHeight) {

            var finalMargin = windowHeight - sidebarHeight - 20;

            $(targetScrollBar).animate({marginTop: finalMargin + 'px'});

        } else if (parseInt(oriTouch) >= 0 || sidebarContainerHeight >= sidebarHeight) {

            $(targetScrollBar).animate({marginTop: '0px'});

        } else {

            finalMargin = oriTouch;

            $(targetScrollBar).animate({marginTop: finalMargin + 'px'});

        }

        return true;

    });

};





/* 05. Handle Sidebar - Clear Sidebar Selection

------------------------------------------------ */

var handleClearSidebarSelection = function() {

    $('.sidebar .nav > li, .sidebar .nav .sub-menu').removeClass('expand').removeAttr('style');

};

var handleClearSidebarMobileSelection = function() {

    $('#page-container').removeClass('page-sidebar-toggled');

};





/* 06. Handle Top Menu - Unlimited Top Menu Render

------------------------------------------------ */

var handleUnlimitedTopMenuRender = function() {

    "use strict";

    // function handle menu button action - next / prev

    function handleMenuButtonAction(element, direction) {

        var obj = $(element).closest('.nav');

        var marginLeft = parseInt($(obj).css('margin-left'));  

        var containerWidth = $('.top-menu').width() - 88;

        var totalWidth = 0;

        var finalScrollWidth = 0;



        $(obj).find('li').each(function() {

            if (!$(this).hasClass('menu-control')) {

                totalWidth += $(this).width();

            }

        });

        

        switch (direction) {

            case 'next':

                var widthLeft = totalWidth + marginLeft - containerWidth;

                if (widthLeft <= containerWidth) {

                    finalScrollWidth = widthLeft - marginLeft + 128;

                    setTimeout(function() {

                        $(obj).find('.menu-control.menu-control-right').removeClass('show');

                    }, 150);

                } else {

                    finalScrollWidth = containerWidth - marginLeft - 128;

                }



                if (finalScrollWidth != 0) {

                    $(obj).animate({ marginLeft: '-' + finalScrollWidth + 'px'}, 150, function() {

                        $(obj).find('.menu-control.menu-control-left').addClass('show');

                    });

                }

                break;

            case 'prev':

                var widthLeft = -marginLeft;

    

                if (widthLeft <= containerWidth) {

                    $(obj).find('.menu-control.menu-control-left').removeClass('show');

                    finalScrollWidth = 0;

                } else {

                    finalScrollWidth = widthLeft - containerWidth + 88;

                }

                $(obj).animate({ marginLeft: '-' + finalScrollWidth + 'px'}, 150, function() {

                    $(obj).find('.menu-control.menu-control-right').addClass('show');

                });

                break;

        }

    }



    // handle page load active menu focus

    function handlePageLoadMenuFocus() {

        var targetMenu = $('.top-menu .nav');

        var targetList = $('.top-menu .nav > li');

        var targetActiveList = $('.top-menu .nav > li.active');

        var targetContainer = $('.top-menu');

        

        var marginLeft = parseInt($(targetMenu).css('margin-left'));  

        var viewWidth = $(targetContainer).width() - 128;

        var prevWidth = $('.top-menu .nav > li.active').width();

        var speed = 0;

        var fullWidth = 0;

        

        $(targetActiveList).prevAll().each(function() {

            prevWidth += $(this).width();

        });



        $(targetList).each(function() {

            if (!$(this).hasClass('menu-control')) {

                fullWidth += $(this).width();

            }

        });



        if (prevWidth >= viewWidth) {

            var finalScrollWidth = prevWidth - viewWidth + 128;

            $(targetMenu).animate({ marginLeft: '-' + finalScrollWidth + 'px'}, speed);

        }

        

        if (prevWidth != fullWidth && fullWidth >= viewWidth) {

            $(targetMenu).find('.menu-control.menu-control-right').addClass('show');

        } else {

            $(targetMenu).find('.menu-control.menu-control-right').removeClass('show');

        }



        if (prevWidth >= viewWidth && fullWidth >= viewWidth) {

            $(targetMenu).find('.menu-control.menu-control-left').addClass('show');

        } else {

            $(targetMenu).find('.menu-control.menu-control-left').removeClass('show');

        }

    }



    // handle menu next button click action

    $('[data-click="next-menu"]').click(function(e) {

        e.preventDefault();

        handleMenuButtonAction(this,'next');

    });



    // handle menu prev button click action

    $('[data-click="prev-menu"]').click(function(e) {

        e.preventDefault();

        handleMenuButtonAction(this,'prev');



    });



    // handle unlimited menu responsive setting

    $(window).resize(function() {

        $('.top-menu .nav').removeAttr('style');

        handlePageLoadMenuFocus();

    });



    handlePageLoadMenuFocus();

};





/* 07. Handle Top Menu - Sub Menu Toggle

------------------------------------------------ */

var handleTopMenuSubMenu = function() {

    "use strict";

    $('.top-menu .sub-menu .has-sub > a').click(function() {

        var target = $(this).closest('li').find('.sub-menu').first();

        var otherMenu = $(this).closest('ul').find('.sub-menu').not(target);

        $(otherMenu).not(target).slideUp(250, function() {

            $(this).closest('li').removeClass('expand');

        });

        $(target).slideToggle(250, function() {

            var targetLi = $(this).closest('li');

            if ($(targetLi).hasClass('expand')) {

                $(targetLi).removeClass('expand');

            } else {

                $(targetLi).addClass('expand');

            }

        });

    });

};





/* 08. Handle Top Menu - Mobile Sub Menu Toggle

------------------------------------------------ */

var handleMobileTopMenuSubMenu = function() {

    "use strict";

    $('.top-menu .nav > li.has-sub > a').click(function() {

        if ($(window).width() <= 767) {

            var target = $(this).closest('li').find('.sub-menu').first();

            var otherMenu = $(this).closest('ul').find('.sub-menu').not(target);

            $(otherMenu).not(target).slideUp(250, function() {

                $(this).closest('li').removeClass('expand');

            });

            $(target).slideToggle(250, function() {

                var targetLi = $(this).closest('li');

                if ($(targetLi).hasClass('expand')) {

                    $(targetLi).removeClass('expand');

                } else {

                    $(targetLi).addClass('expand');

                }

            });

        }

    });

};





/* 09. Handle Top Menu - Mobile Top Menu Toggle

------------------------------------------------ */

var handleTopMenuMobileToggle = function() {

    "use strict";

    $('[data-click="top-menu-toggled"]').click(function() {

        $('.top-menu').slideToggle(250);

    });

};





/* 10. Handle Plugins - Scrollbar

------------------------------------------------ */

var handleSlimScroll = function() {

    "use strict";

    $('[data-scrollbar="true"]').each(function() {

        generateSlimScroll($(this));

    });

};

var generateSlimScroll = function(element) {

    "use strict";

    if ($(element).attr('data-init')) {

        return;

    }

    var dataHeight = $(element).attr('data-height');

        dataHeight = (!dataHeight) ? $(element).height() : dataHeight;

    var dataDistance = $(element).attr('data-distance');

        dataDistance = (!dataDistance) ? '0px' : dataDistance;

    var dataPosition = $(element).attr('data-position');

        dataPosition = (!dataPosition) ? 'right' : dataPosition;



    var scrollBarOption = {

        height: dataHeight, 

        alwaysVisible: true,

        distance: dataDistance,

        position: dataPosition

    };

    if(/Android|webOS|iPhone|iPad|iPod|BlackBerry|IEMobile|Opera Mini/i.test(navigator.userAgent)) {

        $(element).css('height', dataHeight);

        $(element).css('overflow-x','scroll');

    } else {

        $(element).slimScroll(scrollBarOption);

    }

    $(element).attr('data-init', true);

};





/* 11. Handle Plugins - Bootstrap Tooltip & Popover

------------------------------------------------ */

var handleTooltipInit = function() {

    "use strict";

    if ($('[data-toggle="tooltip"]').length !== 0) {

        $('[data-toggle="tooltip"]').tooltip();

    }

};



var handlePopoverInit = function() {

    if ($('[data-toggle="popover"]').length !== 0) {

        $('[data-toggle="popover"]').popover();

    }

};





/* 12. Handle Page Load - Show Content

------------------------------------------------ */

var handlePageLoad = function() {

    "use strict";

    $('#page-loader').addClass('hide');

    $('#page-container').addClass('in');

};





/* 13. Handle Scroll To Top

------------------------------------------------ */

var handleScrollToTopButton = function() {

    "use strict";

    $('[data-click=scroll-top]').click(function(e) {

        e.preventDefault();

        $('html, body').animate({

            scrollTop: $('body').offset().top

        }, 500);

    });

};





/* 14. Handle Panel - Remove / Reload / Collapse / Expand

------------------------------------------------ */

var panelActionRunning = false;

var handlePanelAction = function() {

    "use strict";

    

    if (panelActionRunning) {

        return false;

    }

    panelActionRunning = true;

    

    // remove

    $('[data-click=panel-remove]').hover(function() {

        $(this).tooltip({

            title: 'Remove',

            placement: 'bottom',

            trigger: 'hover',

            container: 'body'

        });

        $(this).tooltip('show');

    });

    $(document).on('click', '[data-click=panel-remove]', function(e) {

        e.preventDefault();

        $(this).tooltip('destroy');

        $(this).closest('.panel').remove();

    });

    

    // collapse

    $(document).on('hover', '[data-click=panel-collapse]', function() {

        $(this).tooltip({

            title: 'Collapse / Expand',

            placement: 'bottom',

            trigger: 'hover',

            container: 'body'

        });

        $(this).tooltip('show');

    });

    $(document).on('click', '[data-click=panel-collapse]', function(e) {

        e.preventDefault();

        $(this).closest('.panel').find('.panel-body').slideToggle();

    });

    

    // reload

    $(document).on('hover', '[data-click=panel-reload]', function() {

        $(this).tooltip({

            title: 'Reload',

            placement: 'bottom',

            trigger: 'hover',

            container: 'body'

        });

        $(this).tooltip('show');

    });

    $(document).on('click', '[data-click=panel-reload]', function(e) {

        e.preventDefault();

        var target = $(this).closest('.panel');

        if (!$(target).hasClass('panel-loading')) {

            var targetBody = $(target).find('.panel-body');

            var spinnerHtml = '<div class="panel-loader"><span class="spinner-small">Loading...</span></div>';

            $(target).addClass('panel-loading');

            $(targetBody).prepend(spinnerHtml);

            setTimeout(function() {

                $(target).removeClass('panel-loading');

                $(target).find('.panel-loader').remove();

            }, 2000);

        }

    });

    

    // expand

    $(document).on('hover', '[data-click=panel-expand]', function() {

        $(this).tooltip({

            title: 'Expand / Compress',

            placement: 'bottom',

            trigger: 'hover',

            container: 'body'

        });

        $(this).tooltip('show');

    });

    $(document).on('click', '[data-click=panel-expand]', function(e) {

        e.preventDefault();

        var target = $(this).closest('.panel');

        var targetClass = 'panel-expand';

        var targetBody = $(target).find('.panel-body');

        var callbackFunction = ($(target).hasClass(targetClass)) ? $(this).attr('data-collapse-callback') : $(this).attr('data-expand-callback');

        

        if (callbackFunction) {

            window[callbackFunction]($(this));

        }

        

        if ($(target).hasClass(targetClass)) {

            $(targetBody).removeAttr('style');

            $(targetBody).find('[data-scrollbar="true"]').each(function() {

                var dataHeight = $(this).attr('data-ori-height');

                $(this).slimScroll({destroy: true});

                $(this).removeAttr('style');

                $(this).attr('data-height', dataHeight);

                generateSlimScroll(this);

            });

            $(target).removeClass(targetClass);

        } else {

            var finalHeight = $(window).height() - $(target).find('.panel-heading').height() - 30;

            $(targetBody).find('[data-scrollbar="true"]').each(function() {

                var dataHeight = $(this).attr('data-height');

                $(this).slimScroll({destroy: true});

                $(this).removeAttr('style');

                $(this).attr('data-ori-height', dataHeight);

                $(this).attr('data-height','100%');

                generateSlimScroll(this);

            });

            $(targetBody).css('height', finalHeight);

            $(target).addClass(targetClass);

        }

        

        $(window).trigger('resize');

    });

};







/* Application Controller

------------------------------------------------ */

var App = function () {

	"use strict";

	

	return {

		initSidebar: function() {

		    handleSidebarMenu();

		    handleMobileSidebarToggle();

		    handleSidebarMinify();

		    handleMobileSidebar();

		},

		initSidebarSelection: function() {

		    handleClearSidebarSelection();

		},

		initSidebarMobileSelection: function() {

		    handleClearSidebarMobileSelection();

		},

		initTopMenu: function() {

		    handleUnlimitedTopMenuRender();

		    handleTopMenuSubMenu();

		    handleMobileTopMenuSubMenu();

		    handleTopMenuMobileToggle();

		},

		initComponent: function() {

		    handleTooltipInit();

		    handlePopoverInit();

		    handlePanelAction();

		    handleSlimScroll();

		    handleScrollToTopButton();

		},

		initPageLoad: function() {

		    handlePageLoad();

		},

		init: function () {

		    this.initTopMenu();

		    this.initSidebar();

		    this.initComponent();

		    this.initPageLoad();

		},

		scrollTop: function() {

            $('html, body').animate({

                scrollTop: $('body').offset().top

            }, 0);

		}

  };

}();