<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddProductFieldColumnProductsTable extends Migration
{
    public $set_table = array('products');

    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        foreach ($this->set_table as $setTable)
        {
            if (!Schema::hasColumn($setTable, "brand_id")) {
                Schema::table($setTable, function (Blueprint $table) {
                    $table->integer('brand_id')->nullable()->default(0)->comment('brand id Ex.รหัส brand')->after("category_id");
                });
            }

            if (!Schema::hasColumn($setTable, "product_name_th")) {
                Schema::table($setTable, function (Blueprint $table) {
                    $table->string('product_name_th',255)->nullable()->default(null)->comment('product name Ex.ชื่อสินค้า')->after("title_th");
                });
            }

            if (!Schema::hasColumn($setTable, "content_th")) {
                Schema::table($setTable, function (Blueprint $table) {
                    $table->text('content_th')->nullable()->default(null)->comment('content Ex.ชื่อสินค้า')->after("detail_en");
                });
            }

            if (!Schema::hasColumn($setTable, "product_name_en")) {
                Schema::table($setTable, function (Blueprint $table) {
                    $table->string('product_name_en',255)->nullable()->default(null)->comment('product name Ex.ชื่อสินค้า')->after("title_en");
                });
            }

            if (!Schema::hasColumn($setTable, "content_en")) {
                Schema::table($setTable, function (Blueprint $table) {
                    $table->text('content_en')->nullable()->default(null)->comment('content Ex.ชื่อสินค้า')->after("detail_en");
                });
            }
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        foreach ($this->set_table as $setTable)
        {
            if (Schema::hasColumn($setTable, "brand_id")) {
                Schema::table($setTable, function (Blueprint $table) {
                    $table->dropColumn("brand_id");
                });
            }

            if (Schema::hasColumn($setTable, "product_name_th")) {
                Schema::table($setTable, function (Blueprint $table) {
                    $table->dropColumn("product_name_th");
                });
            }

            if (Schema::hasColumn($setTable, "product_name_en")) {
                Schema::table($setTable, function (Blueprint $table) {
                    $table->dropColumn("product_name_en");
                });
            }

            if (Schema::hasColumn($setTable, "content_th")) {
                Schema::table($setTable, function (Blueprint $table) {
                    $table->dropColumn("content_th");
                });
            }

            if (Schema::hasColumn($setTable, "content_en")) {
                Schema::table($setTable, function (Blueprint $table) {
                    $table->dropColumn("content_en");
                });
            }
        }
    }
}
