<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Support\Facades\DB;

class AddPermissionCategories extends Migration
{
    public $set_table = 'permissions';
    public $set_category_name = array('Categories');
    public $set_category_permission = array('categories');

    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        foreach ($this->set_category_name as $key => $category_name) {
            $category_permission = $this->set_category_permission[$key];
            $result = DB::table($this->set_table)->orderBy("order_by", "DESC")->first();
            $order_by = $result->order_by;

            //list
            $result_count = DB::table($this->set_table)->where("name", "view-" . $category_permission . "-list")->count();
            if ($result_count == 0) {
                $insert_id = DB::table($this->set_table)->insertGetId([
                    'groups' => 7,
                    'name' => "view-" . $category_permission . "-list",
                    'display_name' => "View " . $category_name . " List",
                    'created_at' => date("Y-m-d H:i:s"),
                    'updated_at' => date("Y-m-d H:i:s"),
                    'order_by' => $order_by + 1,
                ]);
            }

            //create
            $result_count = DB::table($this->set_table)->where("name", "create-" . $category_permission)->count();
            if ($result_count == 0) {
                $insert_id = DB::table($this->set_table)->insertGetId([
                    'groups' => 7,
                    'name' => "create-" . $category_permission,
                    'display_name' => "Create " . $category_name,
                    'created_at' => date("Y-m-d H:i:s"),
                    'updated_at' => date("Y-m-d H:i:s"),
                    'order_by' => $order_by + 2,
                ]);
            }

            //edit
            $result_count = DB::table($this->set_table)->where("name", "edit-".$category_permission)->count();
            if ($result_count == 0) {
                $insert_id = DB::table($this->set_table)->insertGetId([
                    'groups' => 7,
                    'name' => "edit-".$category_permission,
                    'display_name' => "Edit ".$category_name,
                    'created_at' => date("Y-m-d H:i:s"),
                    'updated_at' => date("Y-m-d H:i:s"),
                    'order_by' => $order_by + 3,
                ]);
            }
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {

    }
}
