<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddOurBrandIdColumnBannersTable extends Migration
{
    public $set_table = array('banners');

    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        foreach ($this->set_table as $setTable)
        {
            if (!Schema::hasColumn($setTable, "is_main")) {
                Schema::table($setTable, function (Blueprint $table) {
                    $table->enum('is_main',["Y","N"])->nullable()->default("N")->comment('main Ex.N')->after("id");
                });
            }

            if (!Schema::hasColumn($setTable, "our_brand_id")) {
                Schema::table($setTable, function (Blueprint $table) {
                    $table->integer('our_brand_id')->nullable()->default(null)->comment('our brand Ex.1')->after("id");
                });
            }
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        foreach ($this->set_table as $setTable)
        {
            if (Schema::hasColumn($setTable, "is_main")) {
                Schema::table($setTable, function (Blueprint $table) {
                    $table->dropColumn("is_main");
                });
            }

            if (Schema::hasColumn($setTable, "our_brand_id")) {
                Schema::table($setTable, function (Blueprint $table) {
                    $table->dropColumn("our_brand_id");
                });
            }
        }
    }
}
