<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddContentColumnBrandsTable extends Migration
{
    public $set_table = array('ourBrands');

    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        foreach ($this->set_table as $setTable)
        {
            if (!Schema::hasColumn($setTable, "type")) {
                Schema::table($setTable, function (Blueprint $table) {
                    $table->enum('type',['url','template'])->nullable()->default("url")->comment('content Ex.test')->after("url");
                });
            }

            if (!Schema::hasColumn($setTable, "content_en")) {
                Schema::table($setTable, function (Blueprint $table) {
                    $table->text('content_en')->nullable()->default(null)->comment('content Ex.test')->after("title_en");
                });
            }

            if (!Schema::hasColumn($setTable, "content_th")) {
                Schema::table($setTable, function (Blueprint $table) {
                    $table->text('content_th')->nullable()->default(null)->comment('content Ex.test')->after("title_en");
                });
            }
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        //
    }
}
