<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Support\Facades\DB;

class AddPermissionContents extends Migration
{
    public $set_table = 'permissions';
    public $set_banner_name = array('Brooks','Micas','Hahnes');
    public $set_banner_permission = array('brooks','micas','hahnes');

    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        foreach ($this->set_banner_name as $key => $banner_name) {
            $banner_permission = $this->set_banner_permission[$key];
            $result = DB::table($this->set_table)->orderBy("order_by", "DESC")->first();
            $order_by = $result->order_by;

            //list
            $result_count = DB::table($this->set_table)->where("name", "view-" . $banner_permission . "-list")->count();
            if ($result_count == 0) {
                $insert_id = DB::table($this->set_table)->insertGetId([
                    'groups' => 6,
                    'name' => "view-" . $banner_permission . "-list",
                    'display_name' => "View " . $banner_name . " List",
                    'created_at' => date("Y-m-d H:i:s"),
                    'updated_at' => date("Y-m-d H:i:s"),
                    'order_by' => $order_by + 1,
                ]);
            }

            //create
            $result_count = DB::table($this->set_table)->where("name", "create-" . $banner_permission)->count();
            if ($result_count == 0) {
                $insert_id = DB::table($this->set_table)->insertGetId([
                    'groups' => 6,
                    'name' => "create-" . $banner_permission,
                    'display_name' => "Create " . $banner_name,
                    'created_at' => date("Y-m-d H:i:s"),
                    'updated_at' => date("Y-m-d H:i:s"),
                    'order_by' => $order_by + 2,
                ]);
            }

            //edit
            $result_count = DB::table($this->set_table)->where("name", "edit-".$banner_permission)->count();
            if ($result_count == 0) {
                $insert_id = DB::table($this->set_table)->insertGetId([
                    'groups' => 6,
                    'name' => "edit-".$banner_permission,
                    'display_name' => "Edit ".$banner_name,
                    'created_at' => date("Y-m-d H:i:s"),
                    'updated_at' => date("Y-m-d H:i:s"),
                    'order_by' => $order_by + 3,
                ]);
            }
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {

    }
}
