<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddThumbColumnBanners extends Migration
{
    public $set_table = array('banners');

    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        foreach ($this->set_table as $setTable)
        {
            if (!Schema::hasColumn($setTable, "thumb_mobile")) {
                Schema::table($setTable, function (Blueprint $table) {
                    $table->string('thumb_mobile',255)->nullable()->default(null)->comment('url Ex.thumb')->after("id");
                });
            }
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        //
    }
}
