<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateBrandsTable extends Migration
{
    public $table = "brands";
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        if (!Schema::hasTable($this->table)) {
            Schema::create($this->table, function (Blueprint $table) {
                $table->increments('id')->unsigned();
                $table->string('title_th',255)->nullable()->default(null)->comment('ชื่อ Ex.banner');
                $table->string('title_en',255)->nullable()->default(null)->comment('ชื่อ Ex.banner');
                $table->date('startDate')->nullable()->default(null)->comment('วันที่เริ่ม Ex.2019-01-01');
                $table->date('endDate')->nullable()->default(null)->comment('วันที่สิ้นสุด Ex.2019-01-01');
                $table->string('visitor', 45)->default('000.000.000.000')->comment('Ip Address');
                $table->enum('status', ['Active', 'Inactive'])->default('Active')->comment('Active = ใช้งาน,Inactive=ไม่ใช้งาน');
                $table->timestamps();
                $table->integer('created_by')->default('0')->comment('สร้างโดย');
                $table->integer('updated_by')->default('0')->comment('แก้ไขโดย');
                $table->integer('order_by')->default('0')->comment('ลำดับ');
            });
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('demo', function (Blueprint $table) {
            //
        });
    }
}
