<?php

namespace App\Model;

use Illuminate\Database\Eloquent\Model;
use Carbon\Carbon;
use Auth;

class OurBrands extends Model
{
    protected $table = 'ourBrands';
    public $timestamps = true;

    protected $dates = [
        'startDate',
        'endDate',
        'created_at',
        'updated_at',
    ];

    protected $fillable = [
        'url',
        'type',
        'thumb',
        'title_th',
        'detail_th',
        'content_th',
        'title_en',
        'detail_en',
        'content_en',
        'visitor',
        'status',
        'created_at',
        'updated_at',
        'created_by',
        'updated_by',
        'order_by',
    ];

    //search keyword
    public static function scopeSearchKeyword($query, $search)
    {
    	$query = $query->where(function ($query2) use ($search) {
                        $query2->where('title_th', 'like', '%'.$search.'%')
                                ->orWhere('title_en', 'like', '%'.$search.'%');
	            	});
        return $query;
    }
    //end search keyword

}

