<?php

namespace App\Model;

use Illuminate\Database\Eloquent\Model;
use Carbon\Carbon;
use Auth;

class Hahnes extends Model
{
    protected $table = 'hahnes';
    public $timestamps = true;

    protected $dates = [
        'startDate',
        'endDate',
        'created_at',
        'updated_at',
    ];

    protected $fillable = [
        'url',
        'thumb',
        'title_th',
        'detail_th',
        'weight_th',
        'title_en',
        'detail_en',
        'weight_en',
        'visitor',
        'status',
        'created_at',
        'updated_at',
        'created_by',
        'updated_by',
        'order_by',
    ];

    //search keyword
    public static function scopeSearchKeyword($query, $search)
    {
    	$query = $query->where(function ($query2) use ($search) {
                        $query2->where('title_th', 'like', '%'.$search.'%')
                                ->orWhere('title_en', 'like', '%'.$search.'%');
	            	});
        return $query;
    }
    //end search keyword

    public static function scopeFront($query)
    {
    	$query = $query->whereStatus("Active")->orderBy("order_by","ASC");
        return $query;
    }
}

