<?php

namespace App\Model;

use Illuminate\Database\Eloquent\Model;
use Carbon\Carbon;
use Auth;

class Banners extends Model
{
    protected $table = 'banners';
    public $timestamps = true;

    protected $dates = [
        'startDate',
        'endDate',
        'created_at',
        'updated_at',
    ];

    protected $fillable = [
        'our_brand_id',
        'is_main',
        'url',
        'thumb',
        'thumb_mobile',
        'title',
        'visitor',
        'status',
        'created_at',
        'updated_at',
        'created_by',
        'updated_by',
        'order_by',
    ];

    //search keyword
    public static function scopeSearchKeyword($query, $search)
    {
    	$query = $query->where(function ($query2) use ($search) {
		                $query2->where('title', 'like', '%'.$search.'%');
	            	});
        return $query;
    }
    //end search keyword

}

