<?php

namespace App\Http\Controllers\Webadmin;

use App\Http\Controllers\Controller;
use Auth;
use Carbon\Carbon;
use Request;
use Session;
use Storage;
use Validator;
use QrCode;
use File;
use App\Http\Controllers\Api\ProductBrandsApiController;
use App\Model\ProductBrands;
use App\Model\Categories;
use App\Model\GlobalData;
use App\PermissionRole;


class ProductBrandsController extends Controller
{
    protected $limit_page = 30;

    public function __construct()
    {
        $this->middleware('auth');
        if (Session::has('limit_page.productBrands')) {
            if (Session::get('limit_page.productBrands') == "All") {
                $this->limit_page = ProductBrands::count() + 1;
            } else {
                $this->limit_page = Session::get('limit_page.productBrands');
            }

        } else {
            Session::put('limit_page.productBrands', $this->limit_page);
        }

    }

    public function index(Request $request, $orderBy = "", $ascdesc = "", $search = "")
    {
        $query = ProductBrands::query();
        if (Session::has('limit_page.productBrands')) {
            if (Session::get('limit_page.productBrands') == "All") {
                $this->limit_page = $query->count() + 1;
            } else {
                $this->limit_page = Session::get('limit_page.productBrands');
            }

        } else {
            Session::put('limit_page.productBrands', $this->limit_page);
        }

        $arr_data["orderBy"] = "order_by";
        $arr_data["ascdesc"] = "ASC";
        $arr_data["orderByUrl"] = "order_by";
        $arr_data["urlSearch"] = "";
        $arr_data["status_icon_sort"] = "";

        $search = (isset($search) && $search != "") ? trim($search) : "";
        $orderByUrl = (isset($orderBy) && $orderBy != "") ? $orderBy : "order_by";
        $orderBy = ($orderBy == "") ? "order_by" : $orderBy;
        $orderBy = ($orderBy == "order_by" || $orderBy == "") ? "order_by" : $orderBy;
        $orderBy = ($orderBy == "title") ? "title_th" : $orderBy;
        $orderBy = ($orderBy == "modify") ? "updated_at" : $orderBy;
        $ascdesc = (isset($ascdesc) && $ascdesc != "") ? $ascdesc : "ASC";

        //$arr_data["page"] = $page;
        $arr_data["search"] = $search;
        $arr_data["orderBy"] = $orderBy;
        $arr_data["ascdesc"] = $ascdesc;
        $arr_data["orderByUrl"] = $orderByUrl;
        $arr_data["urlSearch"] = "/" . $search;

        $arr_data["status_icon_sort"] = "";

        $productBrands = new ProductBrandsApiController;
        $data_productBrands = $productBrands->getProductBrandList($request, 2, $orderBy, $ascdesc, $this->limit_page, $search);

        $now = Carbon::now();
        
        if (isset($data_productBrands) && sizeof($data_productBrands) > 0) {
            foreach ($data_productBrands as $productBrand) {
                $pathDate = Carbon::parse($productBrand->created_at)->format("Y/m");
                $pathFile = config('config.config_pathUpload') . '/productBrands/' . $pathDate;
                $productBrand->pathFile = $pathFile;
            }
        }
            

        $arr_data["start_sort"] = $data_productBrands->firstItem() - 1;

        $permission = new PermissionRole;
        $hasPermission = $permission->all_check_permission(Auth::user()->id);
        $getUsersData = GlobalData::getUsersData();

        $data = array(
            "hasPermission" => $hasPermission,
            "productBrands" => $data_productBrands,
            "arr_data" => $arr_data,
            'getUsersData' => $getUsersData,
        );

        if ($hasPermission["view-productBrands-list"]) {
            return view("web-admin.productBrands.index")->with($data);
        } else {
            return redirect(Route("cms.dashboard"));
        }

    }

    public function create(Request $request)
    {
        $productBrands = ProductBrands::select('order_by')->latest('order_by')->first();
        $startDate = "";
        $endDate = "";

        $arr_data = array();
        if (empty($productBrands)) {
            $order = 0;
            $arr_data["order_by"] = 1;
        } else {
            $arr_data["order_by"] = $productBrands->order_by + 1;
        }

        $arr_data["disabled_data"] = false;

        $pathDate = date("Y") . "/" . date("m");

        $categories = Categories::get();
        $productBrandBrands = ProductBrands::get();

        $permission = new PermissionRole;
        $hasPermission = $permission->all_check_permission(Auth::user()->id);
        $data = array(
            "hasPermission" => $hasPermission,
            'arr_data' => $arr_data,
            'pathDate' => $pathDate,
            'categories' => $categories,
            'productBrandBrands' => $productBrandBrands
        );

        if ($hasPermission["create-productBrands"]) {
            return view("web-admin.productBrands.create")->with($data);
        } else {
            return redirect(Route("cms.products.brand.index"));
        }

    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Respons
     */
    public function store(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'title_th' => 'required',
            'title_en' => 'required',
            // 'url' => 'required|url',
        ],
        [
            'title_th.required' => 'กรุณาใส่ชื่อภาษาไทย',
            'title_en.required' => 'กรุณาใส่ชื่อภาษาอังกฤษ',
            // 'url.required' => 'กรุณาใส่ลิงค์',
            // 'url.url' => 'รูปแบบลิงค์ไม่ถูกต้อง! กรุณาใส่ลิงค์ใหม่',
        ]);

        if ($validator->fails()) {
            $message = $validator->errors();
            return redirect()->back()->withErrors($message)->withInput();
        }

        $permission = new PermissionRole;
        $hasPermission = $permission->all_check_permission(Auth::user()->id);

        if ($hasPermission["create-productBrands"]) {
            $productBrand = new ProductBrandsApiController;
            $response = $productBrand->store($request);
            $result = json_decode($response->content(), false);
            $status = $result->success;
        } else {
            $result = "fail";
        }

        if ($status) {
            return redirect()->route('cms.products.brand.indexProcess', ['rs' => "success"]);
            //return redirect(url(config('config.config_pathCms') . '/dealer/productBrands/?rs=success'));
        } else {
            return redirect()->route('cms.products.brand.indexProcess', ['rs' => "error"]);
        }

    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        $productBrand = ProductBrands::find($id);
        if (empty($productBrand)) {
            abort(404);
        }

        $permission = new PermissionRole;
        $hasPermission = $permission->all_check_permission(Auth::user()->id);

        $arr_data["disabled_data"] = true;

        $now = Carbon::now();
        if ($productBrand) {
            $pathDate = Carbon::parse($productBrand->created_at)->format("Y/m");
            $pathFile = config('config.config_pathUpload') . '/productBrands/' . $pathDate;
            $productBrand->pathFile = $pathFile;
        }

        $url = '';
        if ($productBrand->slug) {
            $url = $productBrand->slug;
        }

        $data = array(
            "hasPermission" => $hasPermission,
            "arr_data" => $arr_data,
            "productBrand" => $productBrand,
            'url' => $url
        );

        if ($hasPermission["view-productBrands-list"]) {
            return view('web-admin.productBrands.show')->with($data);
        } else {
            return redirect(url(config('config.config_pathCms')));
        }

    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $productBrand = ProductBrands::find($id);

        if (empty($productBrand)) {
            $order = 0;
            $arr_data["order_by"] = 1;
            abort(404);
        } else {
            $arr_data["order_by"] = $productBrand->order_by;
        }

        $url = '';
        if ($productBrand->slug) {
            $url = $productBrand->slug;
        }

        $now = Carbon::now();
        if ($productBrand) {
            $pathDate = Carbon::parse($productBrand->created_at)->format("Y/m");
            $pathFile = config('config.config_pathUpload') . '/productBrands/' . $pathDate;
            $productBrand->pathFile = $pathFile;
        }

        $arr_data["disabled_data"] = false;

        $permission = new PermissionRole;
        $hasPermission = $permission->all_check_permission(Auth::user()->id);
        $data = array(
            "hasPermission" => $hasPermission,
            "productBrand" => $productBrand,
            "arr_data" => $arr_data,
            'url' => $url
        );

        if ($hasPermission["edit-productBrands"]) {
            return view('web-admin.productBrands.edit')->with($data);
        } else {
            return redirect(Route("cms.products.brand.index"));
        }

    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $productBrands = ProductBrands::find($id);
        if (empty($productBrands)) {
            abort(404);
        }

        $response_success = false;

        $permission = new PermissionRole;
        $hasPermission = $permission->all_check_permission(Auth::user()->id);

        $status = false;
        if ($hasPermission["edit-productBrands"]) {
            $validator = Validator::make($request->all(), [
                'title_th' => 'required',
                'title_en' => 'required',
                // 'url' => 'required|url',
            ],
            [
                'title_th.required' => 'กรุณาใส่ชื่อภาษาไทย',
                'title_en.required' => 'กรุณาใส่ชื่อภาษาอังกฤษ',
                // 'url.required' => 'กรุณาใส่ลิงค์',
                // 'url.url' => 'รูปแบบลิงค์ไม่ถูกต้อง! กรุณาใส่ลิงค์ใหม่',
            ]);

            if ($validator->fails()) {
                $message = $validator->errors();
                return redirect()->back()->withErrors($message)->withInput();
            }

            $productBrand = new ProductBrandsApiController;
            $response = $productBrand->update($request, $id);
            $result = json_decode($response->content(), false);
            $status = $result->success;
        }

        if ($status) {
            return redirect()->route('cms.products.brand.indexProcess', ['rs' => "success"]);
            //return redirect(url(config('config.config_pathCms') . '/dealer/productBrands/?rs=success'));
        } else {
            return redirect()->route('cms.products.brand.indexProcess', ['rs' => "error"]);
        }
    }

    public function destroy($id)
    {
        $productBrand = ProductBrands::find($id);
        if (empty($productBrand)) {
            echo "N";
            exit();
        }

        $permission = new PermissionRole;
        $hasPermission = $permission->all_check_permission(Auth::user()->id);
        if ($hasPermission["edit-productBrands"]) {
            //$result_delete = $productBrands->delete();
            $productBrand = new ProductBrandsApiController;
            $response = $productBrand->delete($id);
            $result = json_decode($response->content(), false);
            $status = $result->success;
            if ($status) {
                echo "Y";
            } else {
                echo "N";
            }

        } else {
            echo "N";
        }
    }

    public function deleteAllSubContent(Request $request)
    {
        $refer_id = $request->refer_id;
        $isError = false;
        if (!empty($refer_id)) {
            foreach ($refer_id as $key => $id) {
                $productBrand = ProductBrands::find($id);
                if (empty($productBrand)) {
                    echo "N";
                    exit();
                }

                $permission = new PermissionRole;
                $hasPermission = $permission->all_check_permission(Auth::user()->id);
                if ($hasPermission["edit-productBrands"]) {
                    //$result_delete = $productBrands->delete();
                    $productBrand = new ProductBrandsApiController;
                    $response = $productBrand->delete($id);
                    $result = json_decode($response->content(), false);
                    $status = $result->success;
                    if (!$status) {
                        $isError = true;
                        echo "N";
                        exit();
                    }
                } else {
                    echo "N";
                    exit();
                }
            }
        } else {
            echo "N";
            exit();
        }

        if (!$isError)
            echo "Y";
    }
}
