<?php

namespace App\Http\Controllers\Webadmin;

use App\Http\Controllers\Controller;
use Auth;
use Carbon\Carbon;
use Request;
use Session;
use Storage;
use Validator;
use App\Http\Controllers\Api\HahnesApiController;
use App\Model\Hahnes;
use App\Model\GlobalData;
use App\PermissionRole;


class HahnesController extends Controller
{
    protected $limit_page = 30;

    public function __construct()
    {
        $this->middleware('auth');
        if (Session::has('limit_page.hahnes')) {
            if (Session::get('limit_page.hahnes') == "All") {
                $this->limit_page = Hahnes::count() + 1;
            } else {
                $this->limit_page = Session::get('limit_page.hahnes');
            }

        } else {
            Session::put('limit_page.hahnes', $this->limit_page);
        }

    }

    public function index(Request $request, $orderBy = "", $ascdesc = "", $search = "")
    {
        $query = Hahnes::query();
        if (Session::has('limit_page.hahnes')) {
            if (Session::get('limit_page.hahnes') == "All") {
                $this->limit_page = $query->count() + 1;
            } else {
                $this->limit_page = Session::get('limit_page.hahnes');
            }

        } else {
            Session::put('limit_page.hahnes', $this->limit_page);
        }

        $arr_data["orderBy"] = "order_by";
        $arr_data["ascdesc"] = "ASC";
        $arr_data["orderByUrl"] = "order_by";
        $arr_data["urlSearch"] = "";
        $arr_data["status_icon_sort"] = "";

        $search = (isset($search) && $search != "") ? trim($search) : "";
        $orderByUrl = (isset($orderBy) && $orderBy != "") ? $orderBy : "order_by";
        $orderBy = ($orderBy == "") ? "order_by" : $orderBy;
        $orderBy = ($orderBy == "order_by" || $orderBy == "") ? "order_by" : $orderBy;
        $orderBy = ($orderBy == "title") ? "title_th" : $orderBy;
        $orderBy = ($orderBy == "modify") ? "updated_at" : $orderBy;
        $ascdesc = (isset($ascdesc) && $ascdesc != "") ? $ascdesc : "ASC";

        //$arr_data["page"] = $page;
        $arr_data["search"] = $search;
        $arr_data["orderBy"] = $orderBy;
        $arr_data["ascdesc"] = $ascdesc;
        $arr_data["orderByUrl"] = $orderByUrl;
        $arr_data["urlSearch"] = "/" . $search;

        $arr_data["status_icon_sort"] = "";

        $hahnes = new HahnesApiController;
        $data_hahnes = $hahnes->getHahneList($request, 2, $orderBy, $ascdesc, $this->limit_page, $search);
        if (!empty($data_hahnes)) {
            foreach ($data_hahnes as $hahne) {
                $pathDate = Carbon::parse($hahne->created_at)->format("Y/m");
                $hahne->pathFile = config('config.config_pathUpload') . '/hahnes/' . $pathDate;
            }
        }

        $arr_data["start_sort"] = $data_hahnes->firstItem() - 1;

        $permission = new PermissionRole;
        $hasPermission = $permission->all_check_permission(Auth::user()->id);
        $getUsersData = GlobalData::getUsersData();

        $data = array(
            "hasPermission" => $hasPermission,
            "hahnes" => $data_hahnes,
            "arr_data" => $arr_data,
            'getUsersData' => $getUsersData,
        );

        if ($hasPermission["view-hahnes-list"]) {
            return view("web-admin.hahnes.index")->with($data);
        } else {
            return redirect(Route("cms.dashboard"));
        }

    }

    public function create(Request $request)
    {
        $hahnes = Hahnes::select('order_by')->latest('order_by')->first();
        $startDate = "";
        $endDate = "";

        $arr_data = array();
        if (empty($hahnes)) {
            $order = 0;
            $arr_data["order_by"] = 1;
        } else {
            $arr_data["order_by"] = $hahnes->order_by + 1;
        }

        $arr_data["disabled_data"] = false;

        $pathDate = date("Y") . "/" . date("m");

        $permission = new PermissionRole;
        $hasPermission = $permission->all_check_permission(Auth::user()->id);
        $data = array(
            "hasPermission" => $hasPermission,
            'arr_data' => $arr_data,
            'pathDate' => $pathDate,
        );

        if ($hasPermission["create-hahnes"]) {
            return view("web-admin.hahnes.create")->with($data);
        } else {
            return redirect(Route("cms.hahnes.index"));
        }

    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Respons
     */
    public function store(Request $request)
    {
        $validator = Validator::make($request->all(), [
            "thumb" => 'mimes:jpg,jpeg,png|max:10000',
            'title_th' => 'required',
            'title_en' => 'required',
            // 'url' => 'required|url',
        ],
        [
            'thumb.mimes' => 'image menu ต้องใช้ไฟล์ jpg,jpeg,png เท่านั้น',
            'thumb.max' => 'ขนาดไฟล์ต้องไม่เกิน 10mb',
            'title_th.required' => 'กรุณาใส่ชื่อภาษาไทย',
            'title_en.required' => 'กรุณาใส่ชื่อภาษาอังกฤษ',
            // 'url.required' => 'กรุณาใส่ลิงค์',
            // 'url.url' => 'รูปแบบลิงค์ไม่ถูกต้อง! กรุณาใส่ลิงค์ใหม่',
        ]);

        if ($validator->fails()) {
            $message = $validator->errors();
            return redirect()->back()->withErrors($message)->withInput();
        }

        $permission = new PermissionRole;
        $hasPermission = $permission->all_check_permission(Auth::user()->id);

        if ($hasPermission["create-hahnes"]) {
            $hahne = new HahnesApiController;
            $response = $hahne->store($request);
            $result = json_decode($response->content(), false);
            $status = $result->success;
        } else {
            $result = "fail";
        }

        if ($status) {
            return redirect()->route('cms.hahnes.indexProcess', ['rs' => "success"]);
            //return redirect(url(config('config.config_pathCms') . '/dealer/hahnes/?rs=success'));
        } else {
            return redirect()->route('cms.hahnes.indexProcess', ['rs' => "error"]);
        }

    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        $hahne = Hahnes::find($id);
        if (empty($hahne)) {
            abort(404);
        }

        $permission = new PermissionRole;
        $hasPermission = $permission->all_check_permission(Auth::user()->id);

        $arr_data["disabled_data"] = true;
        $pathDate = Carbon::parse($hahne->created_at)->format("Y/m");
        $hahne->pathFile = config('config.config_pathUpload') . '/hahnes/' . $pathDate;

        $data = array(
            "hasPermission" => $hasPermission,
            "arr_data" => $arr_data,
            "hahne" => $hahne,
        );

        if ($hasPermission["view-hahnes-list"]) {
            return view('web-admin.hahnes.show')->with($data);
        } else {
            return redirect(url(config('config.config_pathCms')));
        }

    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $hahne = Hahnes::find($id);
        if (empty($hahne)) {
            $order = 0;
            $arr_data["order_by"] = 1;
            abort(404);
        } else {
            $arr_data["order_by"] = $hahne->order_by;
        }

        $arr_data["disabled_data"] = false;
        $pathDate = Carbon::parse($hahne->created_at)->format("Y/m");
        $hahne->pathFile = config('config.config_pathUpload') . '/hahnes/' . $pathDate;

        $permission = new PermissionRole;
        $hasPermission = $permission->all_check_permission(Auth::user()->id);
        $data = array(
            "hasPermission" => $hasPermission,
            "hahne" => $hahne,
            "arr_data" => $arr_data,
        );

        if ($hasPermission["edit-hahnes"]) {
            return view('web-admin.hahnes.edit')->with($data);
        } else {
            return redirect(Route("cms.hahnes.index"));
        }

    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $hahnes = Hahnes::find($id);
        if (empty($hahnes)) {
            abort(404);
        }

        $response_success = false;

        $permission = new PermissionRole;
        $hasPermission = $permission->all_check_permission(Auth::user()->id);

        $status = false;
        if ($hasPermission["edit-hahnes"]) {
            $validator = Validator::make($request->all(), [
                "thumb" => 'mimes:jpg,jpeg,png|max:10000',
                'title_th' => 'required',
                'title_en' => 'required',
                // 'url' => 'required|url',
            ],
            [
                'thumb.mimes' => 'image menu ต้องใช้ไฟล์ jpg,jpeg,png เท่านั้น',
                'thumb.max' => 'ขนาดไฟล์ต้องไม่เกิน 10mb',
                'title_th.required' => 'กรุณาใส่ชื่อภาษาไทย',
                'title_en.required' => 'กรุณาใส่ชื่อภาษาอังกฤษ',
                // 'url.required' => 'กรุณาใส่ลิงค์',
                // 'url.url' => 'รูปแบบลิงค์ไม่ถูกต้อง! กรุณาใส่ลิงค์ใหม่',
            ]);

            if ($validator->fails()) {
                $message = $validator->errors();
                return redirect()->back()->withErrors($message)->withInput();
            }

            $hahne = new HahnesApiController;
            $response = $hahne->update($request, $id);
            $result = json_decode($response->content(), false);
            $status = $result->success;
        }

        if ($status) {
            return redirect()->route('cms.hahnes.indexProcess', ['rs' => "success"]);
            //return redirect(url(config('config.config_pathCms') . '/dealer/hahnes/?rs=success'));
        } else {
            return redirect()->route('cms.hahnes.indexProcess', ['rs' => "error"]);
        }
    }

    public function destroy($id)
    {
        $hahne = Hahnes::find($id);
        if (empty($hahne)) {
            echo "N";
            exit();
        }

        $permission = new PermissionRole;
        $hasPermission = $permission->all_check_permission(Auth::user()->id);
        if ($hasPermission["edit-hahnes"]) {
            //$result_delete = $hahnes->delete();
            $hahne = new HahnesApiController;
            $response = $hahne->delete($id);
            $result = json_decode($response->content(), false);
            $status = $result->success;
            if ($status) {
                echo "Y";
            } else {
                echo "N";
            }

        } else {
            echo "N";
        }
    }

    public function deleteAllSubContent(Request $request)
    {
        $refer_id = $request->refer_id;
        $isError = false;
        if (!empty($refer_id)) {
            foreach ($refer_id as $key => $id) {
                $hahne = Hahnes::find($id);
                if (empty($hahne)) {
                    echo "N";
                    exit();
                }

                $permission = new PermissionRole;
                $hasPermission = $permission->all_check_permission(Auth::user()->id);
                if ($hasPermission["edit-hahnes"]) {
                    //$result_delete = $hahnes->delete();
                    $hahne = new HahnesApiController;
                    $response = $hahne->delete($id);
                    $result = json_decode($response->content(), false);
                    $status = $result->success;
                    if (!$status) {
                        $isError = true;
                        echo "N";
                        exit();
                    }
                } else {
                    echo "N";
                    exit();
                }
            }
        } else {
            echo "N";
            exit();
        }

        if (!$isError)
            echo "Y";
    }

}
