<?php

namespace App\Http\Controllers\Webadmin;

use App\Http\Controllers\Controller;
use Auth;
use Carbon\Carbon;
use Request;
use Session;
use Storage;
use Validator;
use App\Http\Controllers\Api\BrooksApiController;
use App\Model\Brooks;
use App\Model\GlobalData;
use App\PermissionRole;


class BrooksController extends Controller
{
    protected $limit_page = 30;

    public function __construct()
    {
        $this->middleware('auth');
        if (Session::has('limit_page.brooks')) {
            if (Session::get('limit_page.brooks') == "All") {
                $this->limit_page = Brooks::count() + 1;
            } else {
                $this->limit_page = Session::get('limit_page.brooks');
            }

        } else {
            Session::put('limit_page.brooks', $this->limit_page);
        }

    }

    public function index(Request $request, $orderBy = "", $ascdesc = "", $search = "")
    {
        $query = Brooks::query();
        if (Session::has('limit_page.brooks')) {
            if (Session::get('limit_page.brooks') == "All") {
                $this->limit_page = $query->count() + 1;
            } else {
                $this->limit_page = Session::get('limit_page.brooks');
            }

        } else {
            Session::put('limit_page.brooks', $this->limit_page);
        }

        $arr_data["orderBy"] = "order_by";
        $arr_data["ascdesc"] = "ASC";
        $arr_data["orderByUrl"] = "order_by";
        $arr_data["urlSearch"] = "";
        $arr_data["status_icon_sort"] = "";

        $search = (isset($search) && $search != "") ? trim($search) : "";
        $orderByUrl = (isset($orderBy) && $orderBy != "") ? $orderBy : "order_by";
        $orderBy = ($orderBy == "") ? "order_by" : $orderBy;
        $orderBy = ($orderBy == "order_by" || $orderBy == "") ? "order_by" : $orderBy;
        $orderBy = ($orderBy == "title") ? "title_th" : $orderBy;
        $orderBy = ($orderBy == "modify") ? "updated_at" : $orderBy;
        $ascdesc = (isset($ascdesc) && $ascdesc != "") ? $ascdesc : "ASC";

        //$arr_data["page"] = $page;
        $arr_data["search"] = $search;
        $arr_data["orderBy"] = $orderBy;
        $arr_data["ascdesc"] = $ascdesc;
        $arr_data["orderByUrl"] = $orderByUrl;
        $arr_data["urlSearch"] = "/" . $search;

        $arr_data["status_icon_sort"] = "";

        $brooks = new BrooksApiController;
        $data_brooks = $brooks->getBrookList($request, 2, $orderBy, $ascdesc, $this->limit_page, $search);
        if (!empty($data_brooks)) {
            foreach ($data_brooks as $brook) {
                $pathDate = Carbon::parse($brook->created_at)->format("Y/m");
                $brook->pathFile = config('config.config_pathUpload') . '/brooks/' . $pathDate;
            }
        }

        $arr_data["start_sort"] = $data_brooks->firstItem() - 1;

        $permission = new PermissionRole;
        $hasPermission = $permission->all_check_permission(Auth::user()->id);
        $getUsersData = GlobalData::getUsersData();

        $data = array(
            "hasPermission" => $hasPermission,
            "brooks" => $data_brooks,
            "arr_data" => $arr_data,
            'getUsersData' => $getUsersData,
        );

        if ($hasPermission["view-brooks-list"]) {
            return view("web-admin.brooks.index")->with($data);
        } else {
            return redirect(Route("cms.dashboard"));
        }

    }

    public function create(Request $request)
    {
        $brooks = Brooks::select('order_by')->latest('order_by')->first();
        $startDate = "";
        $endDate = "";

        $arr_data = array();
        if (empty($brooks)) {
            $order = 0;
            $arr_data["order_by"] = 1;
        } else {
            $arr_data["order_by"] = $brooks->order_by + 1;
        }

        $arr_data["disabled_data"] = false;

        $pathDate = date("Y") . "/" . date("m");

        $permission = new PermissionRole;
        $hasPermission = $permission->all_check_permission(Auth::user()->id);
        $data = array(
            "hasPermission" => $hasPermission,
            'arr_data' => $arr_data,
            'pathDate' => $pathDate,
        );

        if ($hasPermission["create-brooks"]) {
            return view("web-admin.brooks.create")->with($data);
        } else {
            return redirect(Route("cms.brooks.index"));
        }

    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Respons
     */
    public function store(Request $request)
    {
        $validator = Validator::make($request->all(), [
            "thumb" => 'mimes:jpg,jpeg,png|max:10000',
            'title_th' => 'required',
            'title_en' => 'required',
            // 'url' => 'required|url',
        ],
        [
            'thumb.mimes' => 'image menu ต้องใช้ไฟล์ jpg,jpeg,png เท่านั้น',
            'thumb.max' => 'ขนาดไฟล์ต้องไม่เกิน 10mb',
            'title_th.required' => 'กรุณาใส่ชื่อภาษาไทย',
            'title_en.required' => 'กรุณาใส่ชื่อภาษาอังกฤษ',
            // 'url.required' => 'กรุณาใส่ลิงค์',
            // 'url.url' => 'รูปแบบลิงค์ไม่ถูกต้อง! กรุณาใส่ลิงค์ใหม่',
        ]);

        if ($validator->fails()) {
            $message = $validator->errors();
            return redirect()->back()->withErrors($message)->withInput();
        }

        $permission = new PermissionRole;
        $hasPermission = $permission->all_check_permission(Auth::user()->id);

        if ($hasPermission["create-brooks"]) {
            $brook = new BrooksApiController;
            $response = $brook->store($request);
            $result = json_decode($response->content(), false);
            $status = $result->success;
        } else {
            $result = "fail";
        }

        if ($status) {
            return redirect()->route('cms.brooks.indexProcess', ['rs' => "success"]);
            //return redirect(url(config('config.config_pathCms') . '/dealer/brooks/?rs=success'));
        } else {
            return redirect()->route('cms.brooks.indexProcess', ['rs' => "error"]);
        }

    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        $brook = Brooks::find($id);
        if (empty($brook)) {
            abort(404);
        }

        $permission = new PermissionRole;
        $hasPermission = $permission->all_check_permission(Auth::user()->id);

        $arr_data["disabled_data"] = true;
        $pathDate = Carbon::parse($brook->created_at)->format("Y/m");
        $brook->pathFile = config('config.config_pathUpload') . '/brooks/' . $pathDate;

        $data = array(
            "hasPermission" => $hasPermission,
            "arr_data" => $arr_data,
            "brook" => $brook,
        );

        if ($hasPermission["view-brooks-list"]) {
            return view('web-admin.brooks.show')->with($data);
        } else {
            return redirect(url(config('config.config_pathCms')));
        }

    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $brook = Brooks::find($id);
        if (empty($brook)) {
            $order = 0;
            $arr_data["order_by"] = 1;
            abort(404);
        } else {
            $arr_data["order_by"] = $brook->order_by;
        }

        $arr_data["disabled_data"] = false;
        $pathDate = Carbon::parse($brook->created_at)->format("Y/m");
        $brook->pathFile = config('config.config_pathUpload') . '/brooks/' . $pathDate;

        $permission = new PermissionRole;
        $hasPermission = $permission->all_check_permission(Auth::user()->id);
        $data = array(
            "hasPermission" => $hasPermission,
            "brook" => $brook,
            "arr_data" => $arr_data,
        );

        if ($hasPermission["edit-brooks"]) {
            return view('web-admin.brooks.edit')->with($data);
        } else {
            return redirect(Route("cms.brooks.index"));
        }

    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $brooks = Brooks::find($id);
        if (empty($brooks)) {
            abort(404);
        }

        $response_success = false;

        $permission = new PermissionRole;
        $hasPermission = $permission->all_check_permission(Auth::user()->id);

        $status = false;
        if ($hasPermission["edit-brooks"]) {
            $validator = Validator::make($request->all(), [
                "thumb" => 'mimes:jpg,jpeg,png|max:10000',
                'title_th' => 'required',
                'title_en' => 'required',
                // 'url' => 'required|url',
            ],
            [
                'thumb.mimes' => 'image menu ต้องใช้ไฟล์ jpg,jpeg,png เท่านั้น',
                'thumb.max' => 'ขนาดไฟล์ต้องไม่เกิน 10mb',
                'title_th.required' => 'กรุณาใส่ชื่อภาษาไทย',
                'title_en.required' => 'กรุณาใส่ชื่อภาษาอังกฤษ',
                // 'url.required' => 'กรุณาใส่ลิงค์',
                // 'url.url' => 'รูปแบบลิงค์ไม่ถูกต้อง! กรุณาใส่ลิงค์ใหม่',
            ]);

            if ($validator->fails()) {
                $message = $validator->errors();
                return redirect()->back()->withErrors($message)->withInput();
            }

            $brook = new BrooksApiController;
            $response = $brook->update($request, $id);
            $result = json_decode($response->content(), false);
            $status = $result->success;
        }

        if ($status) {
            return redirect()->route('cms.brooks.indexProcess', ['rs' => "success"]);
            //return redirect(url(config('config.config_pathCms') . '/dealer/brooks/?rs=success'));
        } else {
            return redirect()->route('cms.brooks.indexProcess', ['rs' => "error"]);
        }
    }

    public function destroy($id)
    {
        $brook = Brooks::find($id);
        if (empty($brook)) {
            echo "N";
            exit();
        }

        $permission = new PermissionRole;
        $hasPermission = $permission->all_check_permission(Auth::user()->id);
        if ($hasPermission["edit-brooks"]) {
            //$result_delete = $brooks->delete();
            $brook = new BrooksApiController;
            $response = $brook->delete($id);
            $result = json_decode($response->content(), false);
            $status = $result->success;
            if ($status) {
                echo "Y";
            } else {
                echo "N";
            }

        } else {
            echo "N";
        }
    }

    public function deleteAllSubContent(Request $request)
    {
        $refer_id = $request->refer_id;
        $isError = false;
        if (!empty($refer_id)) {
            foreach ($refer_id as $key => $id) {
                $brook = Brooks::find($id);
                if (empty($brook)) {
                    echo "N";
                    exit();
                }

                $permission = new PermissionRole;
                $hasPermission = $permission->all_check_permission(Auth::user()->id);
                if ($hasPermission["edit-brooks"]) {
                    //$result_delete = $brooks->delete();
                    $brook = new BrooksApiController;
                    $response = $brook->delete($id);
                    $result = json_decode($response->content(), false);
                    $status = $result->success;
                    if (!$status) {
                        $isError = true;
                        echo "N";
                        exit();
                    }
                } else {
                    echo "N";
                    exit();
                }
            }
        } else {
            echo "N";
            exit();
        }

        if (!$isError)
            echo "Y";
    }

}
