<?php

namespace App\Http\Controllers\Front;

use App\Http\Controllers\Controller;
use App\Model\OurBrands;
use Carbon\Carbon;
use Request;
use App\Http\Controllers\Api\BannersApiController;

class OurBrandsController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public $lang;

    //index
    public function index(Request $request)
    {
        $brand = $request->input("brand");
        $ourBrand = OurBrands::find($brand);
        if (!empty($ourBrand) && $ourBrand->count() > 0) {
            $pathDate = Carbon::parse($ourBrand->created_at)->format('Y/m');
            $ourBrand->pathFile = config('config.config_pathUpload').'/ourBrands/'.$pathDate;
        }
//        dd($ourBrand);
//        dd(implode('&', explode('lang=th',url()->full()),'&').'&lang=en', url()->full());

        $banners = new BannersApiController();
        $data_banners = $banners->getBannerListFront($request,$brand);
        if (!empty($data_banners) && $data_banners->count() > 0) {
            foreach ($data_banners as $banner) {
                $pathDate = Carbon::parse($banner->created_at)->format('Y/m');
                $banner->pathFile = config('config.config_pathUpload').'/banners/'.$pathDate;
            }
        }

        $data = array(
            'ourBrand' => $ourBrand,
            "banners" => $data_banners
        );

        return view('front.ourBrand')->with($data);
    }

    
}
