<?php

namespace App\Http\Controllers\Front;

use App\Http\Controllers\Controller;
use Captcha;
//use Illuminate\Http\Response;
use Carbon\Carbon;
use Request;
use Session;
use Validator;
use App\Http\Controllers\Api\BannersApiController;
use App\Http\Controllers\Api\BrandsApiController;
use App\Http\Controllers\Api\OurBrandsApiController;
use App\Http\Controllers\Api\SystemsApiController;
use App\Model\Brands;
use App\Model\Categories;
use App\Model\ProductBrands;
use App\Model\Products;

class MicrositeController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public $lang;

    //index
    // public function index(Request $request, $catSlug = '', $brandSlug = '', $productSlug = '')
    public function index($catSlug = '', $brandSlug = '', $productSlug = '')
    {
        $this->lang = Session::get('locale');

        $category = Categories::whereSlug($catSlug)->first();
        $brand = ProductBrands::whereSlug($brandSlug)->first();

        if (empty($category)) {
            return redirect()->route('home');
        }

        if (empty($brand)) {
            return redirect()->route('home');
        } else {
            $pathDate = Carbon::parse($brand->created_at)->format("Y/m");
            $pathFile = config('config.config_pathUpload') . '/productBrands/' . $pathDate;
            $brand->pathFile = $pathFile;
        }
        

        $product = Products::whereCategoryId($category->id)->whereBrandId($brand->id)->whereSlug($productSlug)->first();
        $pathDate = Carbon::parse($product->created_at)->format("Y/m");
        $pathFile = config('config.config_pathUpload') . '/products/' . $pathDate;
        $product->pathFile = $pathFile;

        if (empty($product)) {
            return redirect()->route('home');
        }

        $data = array(
            'category' => $category,
            'brand' => $brand,
            'product' => $product
        );

        return view('front.microsite')->with($data);
    }
    

}
