<?php

namespace App\Http\Controllers\Front;

use App\Http\Controllers\Controller;
use Captcha;
//use Illuminate\Http\Response;
use Carbon\Carbon;
use Request;
use Session;
use Validator;
use App\Http\Controllers\Api\BannersApiController;
use App\Http\Controllers\Api\BrandsApiController;
use App\Http\Controllers\Api\OurBrandsApiController;
use App\Http\Controllers\Api\SystemsApiController;

class HomeController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public $lang;

    //index
    public function index(Request $request)
    {
        $this->lang = Session::get('locale');
        $banners = new BannersApiController();
        $data_banners = $banners->getBannerListFront($request);
        if (!empty($data_banners) && $data_banners->count() > 0) {
            foreach ($data_banners as $banner) {
                $pathDate = Carbon::parse($banner->created_at)->format('Y/m');
                $banner->pathFile = config('config.config_pathUpload').'/banners/'.$pathDate;
            }
        }

        $ourBrands = new OurBrandsApiController();
        $data_ourBrands = $ourBrands->getOurBrandListFront($request);
        if (!empty($data_ourBrands) && $data_ourBrands->count() > 0) {
            foreach ($data_ourBrands as $ourBrand) {
                $pathDate = Carbon::parse($ourBrand->created_at)->format('Y/m');
                $ourBrand->pathFile = config('config.config_pathUpload').'/ourBrands/'.$pathDate;
            }
        }

        $brands = new BrandsApiController();
        $data_brands = $brands->getBrandListFront($request);
        if (!empty($data_brands) && $data_brands->count() > 0) {
            foreach ($data_brands as $brand) {
                $pathDate = Carbon::parse($brand->created_at)->format('Y/m');
                $brand->pathFile = config('config.config_pathUpload').'/brands/'.$pathDate;
            }
        }

        //$captcha = Captcha::create('default', true);
        $captcha = Captcha::src('default');

        $data = array(
            'banners' => $data_banners,
            'ourBrands' => $data_ourBrands,
            'brands' => $data_brands,
            'captcha' => $captcha,
        );

        return view('front.home')->with($data);
    }

    public function sendContact(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'inputCaptcha' => 'required|captcha',
        ],
        [
            'inputCaptcha.required' => 'กรุณาใส่ Captcha',
            'inputCaptcha.captcha' => 'Captcha ไม่ถูกต้อง! กรุณาใส่ใหม่อีกครั้ง',
        ]);

        if ($validator->fails()) {
            $message = $validator->errors();

            return redirect()->back()->withErrors($message)->withInput();
        }

        $api = new SystemsApiController();
        $response = $api->sendContact($request);
        $result = json_decode($response->content(), false);
        $status = $result->success;
        dd($result);
        if ($status) {
            return redirect()->route('thankyou');
        }
        //return redirect()->route('home', ['rs' => "success"]);
    }

    public function thankyou(Request $request)
    {
        $this->lang = Session::get('locale');
        $banners = new BannersApiController();
        $data_banners = $banners->getBannerListFront($request);
        if (!empty($data_banners) && $data_banners->count() > 0) {
            foreach ($data_banners as $banner) {
                $pathDate = Carbon::parse($banner->created_at)->format('Y/m');
                $banner->pathFile = config('config.config_pathUpload').'/banners/'.$pathDate;
            }
        }

        $data = array(
            'banners' => $data_banners,
        );

        return view('front.thankyou')->with($data);
    }
}
