<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use Request;
use Auth;
use Validator;
use Log;
use File;
use Storage;
use DB;
use Carbon\Carbon;
use Helper;
use App\Model\Banners;

class BannersApiController extends Controller
{
    public function getBannerList(Request $request, $type = 1, $orderBy = 'order_by', $ascdesc = 'asc', $limit_page = 0, $keyword = '')
    {
        $query = Banners::query();

        if ($keyword != '') {
            $query = $query->searchKeyword($keyword);
        }

        $query = $query->orderBy($orderBy, $ascdesc);
        if ($limit_page == 0) {
            $result = $query->get();
        } else {
            $result = $query->paginate($limit_page);
        }

        if ($type == 1) {
            return response()->json(array('status' => 'success', 'data' => $result), 200);
        } else {
            return $result;
        }
    }

    public function getBannerListFront(Request $request,$ourBrand=0)
    {
        $query = Banners::query();
        $query = $query->whereStatus("Active");
        if ($ourBrand!=0)
            $query = $query->whereOurBrandId($ourBrand);
        else
            $query = $query->whereIsMain("Y");
        $query = $query->orderBy("order_by", "ASC");
        $result = $query->get();
        return $result;
    }

    public function index(Request $request)
    {
        try {
            $query = Banners::query();
            if ($request->input('where') !== null) {
                $where = $request->input('where');
                foreach ($where as $key => $value) {
                    $field = $key;
                    $cond = key($value);
                    $var = pos($value);
                    if ($cond == 7)
                        $var = "%" . $var . "%";
    
                    $query = $query->where($field, config("config.config_arr_condition")[$cond], $var);
                }
            }
    
            if ($request->input('order') !== null) {
                $order = $request->input('order');
                foreach ($order as $key => $value) {
                    $query = $query->orderBy($key, $value);
                }
            }
    
            if ($request->input('filter') !== null) {
                $filter = $request->input('filter');
    
                if ($filter["limit"] !== null && $filter["limit"] != 0) {
                    $query = $query->take($filter["limit"]);
                }
                if ($filter["offset"] !== null && $filter["offset"] != 0) {
                    $query = $query->offset(($filter["offset"] - 1));
                }
                if ($filter["skip"] !== null && $filter["skip"] != 0) {
                    $query = $query->skip($filter["skip"]);
                }
            }
    
            $data = $query->get();
    
            return response()->json([
                "success" => true,
                "total" => sizeof($data),
                'data' => $data,
                "msg" => "Get data success"
            ], 200);
        } catch (Exception $e) {
            return response()->json(array('success' => false, 'data' => $e, "message" => "Get all data fail"), 404);
        }
    }

    public function store(Request $request)
    {
        $validator = Validator::make($request->all(), [
            "thumb" => 'mimes:jpg,jpeg,png|max:10000',
            "thumb_mobile" => 'mimes:jpg,jpeg,png|max:10000',
            'title' => 'required',
            // 'url' => 'required|url',
        ],
        [
            'thumb.mimes' => 'image menu ต้องใช้ไฟล์ jpg,jpeg,png เท่านั้น',
            'thumb.max' => 'ขนาดไฟล์ต้องไม่เกิน 10mb',
            'thumb_mobile.mimes' => 'image menu ต้องใช้ไฟล์ jpg,jpeg,png เท่านั้น',
            'thumb_mobile.max' => 'ขนาดไฟล์ต้องไม่เกิน 10mb',
            'title.required' => 'กรุณาใส่ชื่อ',
            // 'url.required' => 'กรุณาใส่ลิงค์',
            // 'url.url' => 'รูปแบบลิงค์ไม่ถูกต้อง! กรุณาใส่ลิงค์ใหม่',
        ]);

        if ($validator->fails()) {
            //return $validation->errors();
            return response()->json([
                "success" => false,
                'data' => null,
                "msg" => $validator->errors()
            ], 422);
        } else {
            $ip_address = $request->ip();
            if ($request->ip() == "::1") {
                $ip_address = "127.0.0.1";
            }

            $now = Carbon::now();
            $current_datetime = $now->toDateTimeString();

            $pathDate = $now->format("Y/m");
            $filenametostore = "";
            if ($request->hasFile('thumb')) {
                $pathFile = config('config.config_pathUpload') . '/banners/' . $pathDate;
                File::isDirectory($pathDate) or File::makeDirectory($pathFile, 0777, true, true);
                $filenametostore = 'thumb-' . time() . '.' . str_replace(" ", "_", $request->thumb->getClientOriginalName());
                Helper::storageProcess("save", $pathFile, $filenametostore, $request->file('thumb'));
            }

            $filenametostoremobile = "";
            if ($request->hasFile('thumb_mobile')) {
                $pathFile = config('config.config_pathUpload') . '/banners/' . $pathDate;
                File::isDirectory($pathDate) or File::makeDirectory($pathFile, 0777, true, true);
                $filenametostoremobile  = 'thumb-' . time() . '.' . str_replace(" ", "_", $request->thumb_mobile->getClientOriginalName());
                Helper::storageProcess("save", $pathFile, $filenametostoremobile, $request->file('thumb_mobile'));
            }

            $startDate = ($request->input("startDate") !== null) ? Carbon::createFromFormat('d/m/Y', $request->input("startDate"))->format("Y-m-d") : NULL;
            $endDate = ($request->input("endDate") !== null) ? Carbon::createFromFormat('d/m/Y', $request->input("endDate"))->format("Y-m-d") : NULL;

            $status = ($request->input("status") !== null) ? $request->input("status") : "Inactive";
            $isMain = ($request->input("isMain") !== null && $request->input("isMain") == "on") ? "Y" : "N";
            $order_by = 0;
            $created_by = ($request->input("created_by") !== null) ? $request->input("created_by") : 0;
            $updated_by = ($request->input("updated_by") !== null) ? $request->input("updated_by") : 0;

            DB::beginTransaction();
            try {
                $banner = new Banners;
                $banner->our_brand_id = $request->input("ourBrand");
                $banner->is_main = $isMain;
                $banner->thumb = $filenametostore;
                $banner->thumb_mobile = $filenametostoremobile;
                $banner->url = $request->input("url");
                $banner->title = $request->input("title");
                $banner->startDate = $startDate;
                $banner->endDate = $endDate;
                $banner->visitor = $ip_address;
                $banner->status = $status;
                $banner->created_at = $current_datetime;
                $banner->updated_at = $current_datetime;
                $banner->created_by = $created_by;
                $banner->updated_by = $updated_by;
                $banner->order_by = $order_by;
                $banner->save();

                $query = Banners::query();
                $update_order = $query->increment("order_by");
                
                $data = array(
                    "banner" => $banner,
                );

                DB::commit();
                return response()->json(array('success' => true, 'data' => $data, "message" => "Successfully inserted"), 200);
            } catch (Exception $e) {
                DB::rollback();
                return response()->json(array('success' => false, 'data' => $e, "message" => "Inserted fail"), 404);
            }
        }
    }

    public function show($id)
    {
        $data = Banners::find($id);
        if (empty($data)) {
            return response()->json([
                "success" => false,
                'data' => "",
                "msg" => ""
            ], 402);
        } else {
            return response()->json([
                "success" => true,
                "total" => $data->count(),
                'data' => $data,
                "msg" => "Get data by id success"
            ], 200);
        }
    }

    public function update(Request $request, $banner_id = 0)
    {
        $validator = Validator::make($request->all(), [
            "thumb" => 'mimes:jpg,jpeg,png|max:10000',
            "thumb_mobile" => 'mimes:jpg,jpeg,png|max:10000',
            'title' => 'required',
            // 'url' => 'required|url',
        ],
        [
            'thumb.mimes' => 'image menu ต้องใช้ไฟล์ jpg,jpeg,png เท่านั้น',
            'thumb.max' => 'ขนาดไฟล์ต้องไม่เกิน 10mb',
            'thumb_mobile.mimes' => 'image menu ต้องใช้ไฟล์ jpg,jpeg,png เท่านั้น',
            'thumb_mobile.max' => 'ขนาดไฟล์ต้องไม่เกิน 10mb',
            'title.required' => 'กรุณาใส่ชื่อ',
            // 'url.required' => 'กรุณาใส่ลิงค์',
            // 'url.url' => 'รูปแบบลิงค์ไม่ถูกต้อง! กรุณาใส่ลิงค์ใหม่',
        ]);

        if ($validator->fails()) {
            //return $validation->errors();
            return response()->json([
                "success" => false,
                'data' => null,
                "msg" => $validator->errors()
            ], 422);
        } else {

            $ip_address = $request->ip();
            if ($request->ip() == "::1") {
                $ip_address = "127.0.0.1";
            }

            $banner = Banners::find($banner_id);
            if (empty($banner)) {
                return response()->json(array('success' => false, 'data' => null, 'message' => 'No Data'), 200);
            }

            $now = Carbon::now();
            $current_datetime = $now->toDateTimeString();

            $pathDate = Carbon::parse($banner->created_at)->format("Y/m");
            $pathFile = config('config.config_pathUpload') . '/banners/' . $pathDate;

            $filenametostore = $banner->thumb;
            if ($request->action_thumb=="delete")
            {
                $responDelete = Helper::storageProcess("delete", $pathFile, $filenametostore);
                $filenametostore = "";
            }
            if ($request->hasFile('thumb')) {
                File::isDirectory($pathDate) or File::makeDirectory($pathFile, 0777, true, true);
                $new_filenametostore = 'thumb-' . time() . '.' . str_replace(" ", "_", $request->thumb->getClientOriginalName());

                $responUpload = Helper::storageProcess("save", $pathFile, $new_filenametostore, $request->file('thumb'));
                if ($responUpload)
                {
                    $responDelete = Helper::storageProcess("delete", $pathFile, $filenametostore);
                    $filenametostore = $new_filenametostore;
                }
            }


            $filenametostoremobile = $banner->thumb_mobile;
            if ($request->action_thumb_mobile=="delete")
            {
                $responDelete = Helper::storageProcess("delete", $pathFile, $filenametostoremobile);
                $filenametostoremobile = "";
            }
            if ($request->hasFile('thumb_mobile')) {
                File::isDirectory($pathDate) or File::makeDirectory($pathFile, 0777, true, true);
                $new_filenametostoremobile = 'thumb-' . time() . '.' . str_replace(" ", "_", $request->thumb_mobile->getClientOriginalName());

                $responUploadmobile = Helper::storageProcess("save", $pathFile, $new_filenametostoremobile, $request->file('thumb_mobile'));
                if ($responUploadmobile)
                {
                    $responDeletemobile = Helper::storageProcess("delete", $pathFile, $filenametostoremobile);
                    $filenametostoremobile = $new_filenametostoremobile;
                }
            }

            $startDate = ($request->input("startDate") !== null) ? Carbon::createFromFormat('d/m/Y', $request->input("startDate"))->format("Y-m-d") : $banner->startDate;
            $endDate = ($request->input("endDate") !== null) ? Carbon::createFromFormat('d/m/Y', $request->input("endDate"))->format("Y-m-d") : $banner->endDate;

            $status = ($request->input("status") !== null) ? $request->input("status") : $banner->status;
            $isMain = ($request->input("isMain") !== null && $request->input("isMain") == "on") ? "Y" : "N";
            // $isMain = ($request->input("isMain") !== null) ? $request->input("isMain") : $banner->is_main;
            $order_by = ($request->input("order_by") !== null) ? $request->input("order_by") : $banner->order_by;
            $created_by = ($request->input("created_by") !== null) ? $request->input("created_by") : 0;
            $updated_by = ($request->input("updated_by") !== null) ? $request->input("updated_by") : 0;

            DB::beginTransaction();
            try {
                $banner->our_brand_id = $request->input("ourBrand");
                $banner->is_main = $isMain;
                $banner->thumb = $filenametostore;
                $banner->thumb_mobile = $filenametostoremobile;
                $banner->url = $request->input("url");
                $banner->title = $request->input("title");
                $banner->startDate = $startDate;
                $banner->endDate = $endDate;
                $banner->visitor = $ip_address;
                $banner->status = $status;
                $banner->updated_at = $current_datetime;
                $banner->updated_by = $updated_by;
                $banner->order_by = $order_by;

                $banner->save();

                $data = array(
                    "banner" => $banner,
                );

                DB::commit();
                return response()->json(array('success' => true, 'data' => $data, "message" => "Successfully updated"), 200);
            } catch (Exception $e) {
                DB::rollback();
                return response()->json(array('success' => false, 'data' => $e, "message" => "Updated fail"), 404);
            }
        }
    }

    public function delete($id)
    {
        DB::beginTransaction();
        try {
            $banner = Banners::find($id);

            $pathDate = Carbon::parse($banner->created_at)->format("Y/m");
            $filenametostore = $banner->thumb;
            $filenametostoremobile = $banner->thumb_mobile;
            $pathFile = config('config.config_pathUpload') . '/banners/' . $pathDate;
            $responDelete = Helper::storageProcess("delete", $pathFile, $filenametostore);
            $responDeletemobile = Helper::storageProcess("delete", $pathFile, $filenametostoremobile);

            $banner->delete();

            $banners = Banners::orderBy("order_by","asc")->get();
            if ($banners && $banners->count() > 0) {
                foreach ($banners as $key => $value) {
                    $dataUpdate = array(
                        "order_by" => $key + 1,
                    );
                    $value->update($dataUpdate);
                }
            }

            $data = array(
                "id" => $id
            );

            DB::commit();
            return response()->json([
                "success" => true,
                'data' => $data,
                "msg" => "Banner - delete data success"
            ], 200);
        } catch (\Exception $e) {
            DB::rollback();
            return response()->json([
                "success" => false,
                'data' => "",
                "msg" => "Banner - error"
            ], 502);
        }
    }
}
