<?php

namespace App\Http\Classes;

use Carbon\Carbon;
use Storage;
use Illuminate\Support\Str;
use Request;
use Session;
use Auth;
use DB;
use App\Model\GlobalData;
use App\Model\Functions\Functionphp;

Class Helper
{
    public static function showThaiDate($date, $type = 'long', $lang = "")
    {
        if (empty($date))
            return null;
        try {

            if ($lang == "")
                $lang = \App::getLocale();

            if ($lang == 'th') {
                setlocale(LC_TIME, 'th_TH.utf8');
                if ($type == 'short') {
                    return Carbon::parse($date)->formatLocalized('%d %b %Ey');
                } else {
                    return Carbon::parse($date)->formatLocalized('%d %B %Ey');
                }

            } else {
                setlocale(LC_TIME, 'en_US.utf8');
                if ($type == 'short') {
                    return Carbon::parse($date)->formatLocalized('%d %b %Y');
                } else {
                    return Carbon::parse($date)->formatLocalized('%d %B %Y');
                }
            }
        } catch (\Exception $e) {
            return $date;
        }

    }

    public static function vatCalculate($number)
    {
        return ($number / 1.07) * 0.07;
    }

    public static function moneyFormat($number, $dec = 0)
    {
        if (!isset($number)) {
            $number = 0;
        }
        return number_format($number, $dec);
    }

    public static function discountPercent($price, $disc_price, $dec = 2)
    {
        $disPercent = 0;
        if ($price != "" && $price != 0)
            $disPercent = ($price - $disc_price) / $price * 100;

        return round($disPercent, $dec);
    }

    public static function percentPerTotal($price, $disc_price, $dec = 2)
    {
        $disPercent = 0;
        if ($price != "" && $price != 0)
            $disPercent = $disc_price/$price*100;

        return round($disPercent, $dec);
    }

    public static function storageProcess($type, $pathFile="", $filename = null, $requestFile = null)
    {
        $doEnable = env('DO_SPACES_ENABLE')?env('DO_SPACES_ENABLE'):false;
        $uploadFile = $pathFile."/".$filename;
        switch ($type) {
            case 'save':
                if ($requestFile !== null && $filename !== null && $filename != "") {
                    if ($doEnable)
                    {
                        $response = Storage::disk('do_spaces')->putFileAs($pathFile, $requestFile, $filename, 'public');
                    }
                    else
                    {
                        $response = Storage::putFileAs($pathFile, $requestFile, $filename, 'public');
                        //Storage::setVisibility($pathFile.$filename, 'public'); // Set the visibility to public.
                    }
                    return $response;
                }
                return false;
                break;

            case 'delete':
                if ($filename !== null && $filename != "") {
                    if ($doEnable)
                    {
                        if (Storage::disk('do_spaces')->exists($uploadFile)) {
                            Storage::disk('do_spaces')->delete($uploadFile);
                            return true;
                        }
                    }
                    else
                    {
                        if (Storage::exists($uploadFile)) {
                            Storage::delete($uploadFile);
                            return true;
                        }
                    }
                }
                return false;
                break;

            case 'exists':
                if ($filename !== null && $filename != "") {
                    if ($doEnable)
                    {
                        if (Storage::disk('do_spaces')->exists($uploadFile))
                            return true;
                    }
                    else
                    {
                        if (Storage::exists($uploadFile))
                            return true;
                    }
                }
                return false;
                break;

            case 'get':

                $url_file = "";
                if ($filename !== null && $filename != "") {
                    if ($doEnable)
                    {
                        if (Storage::disk('do_spaces')->exists($uploadFile)) {
                            $url_file = Storage::disk('do_spaces')->url($uploadFile);
                        }
                    }
                    else
                    {
                        if (Storage::exists($uploadFile)) {
                            $url_file = Storage::url($uploadFile);
                        }
                    }
                }
                return $url_file;
                break;
        }
        return null;
    }


    public static function curl_customRequest($url, $data ,$custom="PATCH", $refer = "", $timeout = 10, $header = [])
    {
        $ssl = stripos($url,'https://') === 0 ? true : false;
        $curlObj = curl_init();
        $options = [
            CURLOPT_URL => $url,
            CURLOPT_RETURNTRANSFER => 1,
            CURLOPT_FOLLOWLOCATION => 1,
            CURLOPT_AUTOREFERER => 1,
            CURLOPT_CUSTOMREQUEST => $custom,
            CURLOPT_USERAGENT => 'Mozilla/5.0 (compatible; MSIE 5.01; Windows NT 5.0)',
            CURLOPT_TIMEOUT => $timeout,
            CURLOPT_POSTFIELDS => $data,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_0,
            CURLOPT_HTTPHEADER => ['Expect:'],
            CURLOPT_IPRESOLVE => CURL_IPRESOLVE_V4,
        ];
        if (!empty($header)) {
            $options[CURLOPT_HTTPHEADER] = $header;
        }
        if ($refer) {
            $options[CURLOPT_REFERER] = $refer; 
        }
        if ($ssl) {
            //support https
            $options[CURLOPT_SSL_VERIFYHOST] = false;
            $options[CURLOPT_SSL_VERIFYPEER] = false;
        }
        curl_setopt_array($curlObj, $options);
        $returnData = curl_exec($curlObj);
        if (curl_errno($curlObj)) {
            //error message
            $returnData = curl_error($curlObj);
        }
        curl_close($curlObj);
        return $returnData;
    }

    public static function curl_getRequest($url, $refer = "", $timeout = 10, $header = [])
    {
        $ssl = stripos($url,'https://') === 0 ? true : false;
        $curlObj = curl_init();
        $options = [
            CURLOPT_URL => $url,
            CURLOPT_RETURNTRANSFER => 1,
            CURLOPT_FOLLOWLOCATION => 1,
            CURLOPT_AUTOREFERER => 1,
            CURLOPT_USERAGENT => 'Mozilla/5.0 (compatible; MSIE 5.01; Windows NT 5.0)',
            CURLOPT_TIMEOUT => $timeout,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_0,
            CURLOPT_HTTPHEADER => ['Expect:'],
            CURLOPT_IPRESOLVE => CURL_IPRESOLVE_V4,
        ];
        if (!empty($header)) {
            $options[CURLOPT_HTTPHEADER] = $header;
        }
        if ($refer) {
            $options[CURLOPT_REFERER] = $refer; 
        }
        if ($ssl) {
            //support https
            $options[CURLOPT_SSL_VERIFYHOST] = false;
            $options[CURLOPT_SSL_VERIFYPEER] = false;
        }
        curl_setopt_array($curlObj, $options);
        $returnData = curl_exec($curlObj);
        if (curl_errno($curlObj)) {
            //error message
            $returnData = curl_error($curlObj);
        }
        curl_close($curlObj);
        return $returnData;
    }

    public static function curl_postRequest($url, $data, $refer = "", $timeout = 10, $header = [])
    {
        $curlObj = curl_init();
        $ssl = stripos($url,'https://') === 0 ? true : false;
        $options = [
            CURLOPT_URL => $url,
            CURLOPT_RETURNTRANSFER => 1,
            CURLOPT_POST => 1,
            CURLOPT_POSTFIELDS => $data,
            CURLOPT_FOLLOWLOCATION => 1,
            CURLOPT_AUTOREFERER => 1,
            CURLOPT_USERAGENT => 'Mozilla/5.0 (compatible; MSIE 5.01; Windows NT 5.0)',
            CURLOPT_TIMEOUT => $timeout,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_0,
            CURLOPT_HTTPHEADER => ['Expect:'],
            CURLOPT_IPRESOLVE => CURL_IPRESOLVE_V4,
            CURLOPT_REFERER => $refer
        ];
        if (!empty($header)) {
            $options[CURLOPT_HTTPHEADER] = $header;
        }
        if ($refer) {
            $options[CURLOPT_REFERER] = $refer;
        }
        if ($ssl) {
            //support https
            $options[CURLOPT_SSL_VERIFYHOST] = false;
            $options[CURLOPT_SSL_VERIFYPEER] = false;
        }
        curl_setopt_array($curlObj, $options);
        $returnData = curl_exec($curlObj);
        if (curl_errno($curlObj)) {
            //error message
            $returnData = curl_error($curlObj);
        }
        curl_close($curlObj);
        return $returnData;
    }
}